import getOptionProperty from './getOptionProperty';
export function isDisabledOption(index, items) {
    const option = items[index];
    return !!option && !!getOptionProperty(option, 'disabled');
}
export function skipDisabledOptions(currentIndex, key, items) {
    let newIndex = currentIndex;
    while (isDisabledOption(newIndex, items)) {
        newIndex += key === 'ArrowUp' ? -1 : 1;
    }
    return newIndex;
}
export default function getUpdatedActiveIndex(currentIndex, key, items) {
    let newIndex = currentIndex;
    newIndex += key === 'ArrowUp' ? -1 : 1;
    newIndex = skipDisabledOptions(newIndex, key, items);
    if (newIndex === items.length) {
        newIndex = -1;
    }
    else if (newIndex === -2) {
        newIndex = items.length - 1;
        newIndex = skipDisabledOptions(newIndex, key, items);
    }
    return newIndex;
}
