import { getOptionLabel } from '../utils';
export function getInitialState(props) {
    const { defaultInputValue, defaultOpen, defaultSelected, maxResults, multiple, } = props;
    let selected = props.selected
        ? props.selected.slice()
        : defaultSelected.slice();
    let text = defaultInputValue;
    if (!multiple && selected.length) {
        text = getOptionLabel(selected[0], props.labelKey);
        if (selected.length > 1) {
            selected = selected.slice(0, 1);
        }
    }
    return {
        activeIndex: -1,
        activeItem: undefined,
        initialItem: undefined,
        isFocused: false,
        selected,
        showMenu: defaultOpen,
        shownResults: maxResults,
        text,
    };
}
export function clearTypeahead(state, props) {
    return {
        ...getInitialState(props),
        isFocused: state.isFocused,
        selected: [],
        text: '',
    };
}
export function clickOrFocusInput(state) {
    return {
        ...state,
        isFocused: true,
        showMenu: true,
    };
}
export function hideMenu(state, props) {
    const { activeIndex, activeItem, initialItem, shownResults } = getInitialState(props);
    return {
        ...state,
        activeIndex,
        activeItem,
        initialItem,
        showMenu: false,
        shownResults,
    };
}
export function toggleMenu(state, props) {
    return state.showMenu ? hideMenu(state, props) : { ...state, showMenu: true };
}
