import { ReflectionKind, } from 'typedoc';
export function hasUsefulTypeDetails(type) {
    return type.visit(isUsefulVisitor) ?? false;
}
const isUsefulVisitor = {
    array(type) {
        return hasUsefulTypeDetails(type.elementType);
    },
    intersection(type) {
        return type.types.some(hasUsefulTypeDetails);
    },
    union(type) {
        return !!type.elementSummaries || type.types.some(hasUsefulTypeDetails);
    },
    reflection(type) {
        return renderingChildIsUseful(type.declaration);
    },
    reference(type) {
        return shouldExpandReference(type);
    },
};
function renderingChildIsUseful(refl) {
    if (renderingThisChildIsUseful(refl)) {
        return true;
    }
    return refl.getProperties().some(renderingThisChildIsUseful);
}
function renderingThisChildIsUseful(refl) {
    if (refl.hasComment())
        return true;
    const declaration = refl.type?.type === 'reflection' ? refl.type.declaration : refl;
    if (declaration.hasComment())
        return true;
    return declaration.getAllSignatures().some((sig) => {
        return sig.hasComment() || sig.parameters?.some((p) => p.hasComment());
    });
}
const expanded = new Set();
function shouldExpandReference(reference) {
    const target = reference.reflection;
    if (reference.highlightedProperties) {
        return !target || expanded.has(target) === false;
    }
    if (!target?.kindOf(ReflectionKind.TypeAlias | ReflectionKind.Interface))
        return false;
    if (!target.comment?.hasModifier('@expand'))
        return false;
    return expanded.has(target) === false;
}
