import PropTypes from 'prop-types';
import React, { useState, } from 'react';
import { useRootClose } from '../components/RootClose';
import { getDisplayName, isFunction, warn } from '../utils';
import { optionType } from '../propTypes';
const propTypes = {
    onBlur: PropTypes.func,
    onClick: PropTypes.func,
    onFocus: PropTypes.func,
    onRemove: PropTypes.func,
    option: optionType.isRequired,
};
export function useToken({ onBlur, onClick, onFocus, onRemove, option, ...props }) {
    const [active, setActive] = useState(false);
    const handleBlur = (e) => {
        setActive(false);
        onBlur && onBlur(e);
    };
    const handleClick = (e) => {
        setActive(true);
        onClick && onClick(e);
    };
    const handleFocus = (e) => {
        setActive(true);
        onFocus && onFocus(e);
    };
    const handleRemove = () => {
        onRemove && onRemove(option);
    };
    const handleKeyDown = (e) => {
        if (e.key === 'Backspace' && active) {
            e.preventDefault();
            handleRemove();
        }
    };
    const attachRef = useRootClose(handleBlur, {
        ...props,
        disabled: !active,
    });
    return {
        active,
        onBlur: handleBlur,
        onClick: handleClick,
        onFocus: handleFocus,
        onKeyDown: handleKeyDown,
        onRemove: isFunction(onRemove) ? handleRemove : undefined,
        ref: attachRef,
    };
}
export function withToken(Component) {
    warn(false, 'Warning: `withToken` is deprecated and will be removed in the next ' +
        'major version. Use `useToken` instead.');
    const displayName = `withToken(${getDisplayName(Component)})`;
    const WrappedToken = (props) => (React.createElement(Component, { ...props, ...useToken(props) }));
    WrappedToken.displayName = displayName;
    WrappedToken.propTypes = propTypes;
    return WrappedToken;
}
