import type { Nfsv4FType, Nfsv4TimeHow, Nfsv4DelegType } from './constants';
export declare class Nfsv4Time {
    readonly seconds: bigint;
    readonly nseconds: number;
    constructor(seconds: bigint, nseconds: number);
}
export declare class Nfsv4SpecData {
    readonly specdata1: number;
    readonly specdata2: number;
    constructor(specdata1: number, specdata2: number);
}
export declare class Nfsv4Fh {
    readonly data: Uint8Array;
    constructor(data: Uint8Array);
}
export declare class Nfsv4Verifier {
    readonly data: Uint8Array;
    constructor(data: Uint8Array);
}
export declare class Nfsv4Fsid {
    readonly major: bigint;
    readonly minor: bigint;
    constructor(major: bigint, minor: bigint);
}
export declare class Nfsv4Stateid {
    readonly seqid: number;
    readonly other: Uint8Array;
    constructor(seqid: number, other: Uint8Array);
}
export declare class Nfsv4ChangeInfo {
    readonly atomic: boolean;
    readonly before: bigint;
    readonly after: bigint;
    constructor(atomic: boolean, before: bigint, after: bigint);
}
export declare class Nfsv4SetTime {
    readonly how: Nfsv4TimeHow;
    readonly time?: Nfsv4Time | undefined;
    constructor(how: Nfsv4TimeHow, time?: Nfsv4Time | undefined);
}
export declare class Nfsv4Bitmap {
    readonly mask: number[];
    constructor(mask: number[]);
}
export declare class Nfsv4Fattr {
    readonly attrmask: Nfsv4Bitmap;
    readonly attrVals: Uint8Array;
    constructor(attrmask: Nfsv4Bitmap, attrVals: Uint8Array);
}
export declare class Nfsv4ClientAddr {
    readonly rNetid: string;
    readonly rAddr: string;
    constructor(rNetid: string, rAddr: string);
}
export declare class Nfsv4CbClient {
    readonly cbProgram: number;
    readonly cbLocation: Nfsv4ClientAddr;
    constructor(cbProgram: number, cbLocation: Nfsv4ClientAddr);
}
export declare class Nfsv4ClientId {
    readonly verifier: Nfsv4Verifier;
    readonly id: Uint8Array;
    constructor(verifier: Nfsv4Verifier, id: Uint8Array);
}
export declare class Nfsv4OpenOwner {
    readonly clientid: bigint;
    readonly owner: Uint8Array;
    constructor(clientid: bigint, owner: Uint8Array);
}
export declare class Nfsv4LockOwner {
    readonly clientid: bigint;
    readonly owner: Uint8Array;
    constructor(clientid: bigint, owner: Uint8Array);
}
export declare class Nfsv4OpenToLockOwner {
    readonly openSeqid: number;
    readonly openStateid: Nfsv4Stateid;
    readonly lockSeqid: number;
    readonly lockOwner: Nfsv4LockOwner;
    constructor(openSeqid: number, openStateid: Nfsv4Stateid, lockSeqid: number, lockOwner: Nfsv4LockOwner);
}
export declare class Nfsv4FsLocation {
    readonly server: string[];
    readonly rootpath: string[];
    constructor(server: string[], rootpath: string[]);
}
export declare class Nfsv4FsLocations {
    readonly fsRoot: string[];
    readonly locations: Nfsv4FsLocation[];
    constructor(fsRoot: string[], locations: Nfsv4FsLocation[]);
}
export declare class Nfsv4Ace {
    readonly type: number;
    readonly flag: number;
    readonly accessMask: number;
    readonly who: string;
    constructor(type: number, flag: number, accessMask: number, who: string);
}
export declare class Nfsv4Acl {
    readonly aces: Nfsv4Ace[];
    constructor(aces: Nfsv4Ace[]);
}
export declare class Nfsv4SecInfo {
    readonly flavor: number;
    readonly flavorInfo?: Uint8Array | undefined;
    constructor(flavor: number, flavorInfo?: Uint8Array | undefined);
}
export declare class Nfsv4OpenClaimNull {
    readonly file: string;
    constructor(file: string);
}
export declare class Nfsv4OpenClaimPrevious {
    readonly delegateType: Nfsv4DelegType;
    constructor(delegateType: Nfsv4DelegType);
}
export declare class Nfsv4OpenClaimDelegateCur {
    readonly delegateStateid: Nfsv4Stateid;
    readonly file: string;
    constructor(delegateStateid: Nfsv4Stateid, file: string);
}
export declare class Nfsv4OpenClaimDelegatePrev {
    readonly file: string;
    constructor(file: string);
}
export declare class Nfsv4OpenClaim {
    readonly claimType: number;
    readonly claim: Nfsv4OpenClaimNull | Nfsv4OpenClaimPrevious | Nfsv4OpenClaimDelegateCur | Nfsv4OpenClaimDelegatePrev;
    constructor(claimType: number, claim: Nfsv4OpenClaimNull | Nfsv4OpenClaimPrevious | Nfsv4OpenClaimDelegateCur | Nfsv4OpenClaimDelegatePrev);
}
export declare class Nfsv4OpenReadDelegation {
    readonly stateid: Nfsv4Stateid;
    readonly recall: boolean;
    readonly permissions: Nfsv4Ace[];
    constructor(stateid: Nfsv4Stateid, recall: boolean, permissions: Nfsv4Ace[]);
}
export declare class Nfsv4OpenWriteDelegation {
    readonly stateid: Nfsv4Stateid;
    readonly recall: boolean;
    readonly spaceLimit: bigint;
    readonly permissions: Nfsv4Ace[];
    constructor(stateid: Nfsv4Stateid, recall: boolean, spaceLimit: bigint, permissions: Nfsv4Ace[]);
}
export declare class Nfsv4OpenDelegation {
    readonly delegationType: Nfsv4DelegType;
    readonly delegation?: Nfsv4OpenReadDelegation | Nfsv4OpenWriteDelegation | undefined;
    constructor(delegationType: Nfsv4DelegType, delegation?: Nfsv4OpenReadDelegation | Nfsv4OpenWriteDelegation | undefined);
}
export declare class Nfsv4Entry {
    readonly cookie: bigint;
    readonly name: string;
    readonly attrs: Nfsv4Fattr;
    readonly nextEntry?: Nfsv4Entry | undefined;
    constructor(cookie: bigint, name: string, attrs: Nfsv4Fattr, nextEntry?: Nfsv4Entry | undefined);
}
export declare class Nfsv4LockNewOwner {
    readonly openToLockOwner: Nfsv4OpenToLockOwner;
    constructor(openToLockOwner: Nfsv4OpenToLockOwner);
}
export declare class Nfsv4LockExistingOwner {
    readonly lockStateid: Nfsv4Stateid;
    readonly lockSeqid: number;
    constructor(lockStateid: Nfsv4Stateid, lockSeqid: number);
}
export declare class Nfsv4LockOwnerInfo {
    readonly newLockOwner: boolean;
    readonly owner: Nfsv4LockNewOwner | Nfsv4LockExistingOwner;
    constructor(newLockOwner: boolean, owner: Nfsv4LockNewOwner | Nfsv4LockExistingOwner);
}
export declare class Nfsv4CreateTypeFile {
    readonly createattrs: Nfsv4Fattr;
    constructor(createattrs: Nfsv4Fattr);
}
export declare class Nfsv4CreateTypeLink {
    readonly linkdata: string;
    readonly createattrs: Nfsv4Fattr;
    constructor(linkdata: string, createattrs: Nfsv4Fattr);
}
export declare class Nfsv4CreateTypeDevice {
    readonly devdata: Nfsv4SpecData;
    readonly createattrs: Nfsv4Fattr;
    constructor(devdata: Nfsv4SpecData, createattrs: Nfsv4Fattr);
}
export declare class Nfsv4CreateTypeOther {
    readonly createattrs: Nfsv4Fattr;
    constructor(createattrs: Nfsv4Fattr);
}
export declare class Nfsv4CreateType {
    readonly type: Nfsv4FType;
    readonly objtype: Nfsv4CreateTypeFile | Nfsv4CreateTypeLink | Nfsv4CreateTypeDevice | Nfsv4CreateTypeOther;
    constructor(type: Nfsv4FType, objtype: Nfsv4CreateTypeFile | Nfsv4CreateTypeLink | Nfsv4CreateTypeDevice | Nfsv4CreateTypeOther);
}
export declare const enum Nfsv4RpcSecGssService {
    RPC_GSS_SVC_NONE = 1,
    RPC_GSS_SVC_INTEGRITY = 2,
    RPC_GSS_SVC_PRIVACY = 3
}
export declare class Nfsv4RpcSecGssInfo {
    readonly oid: Uint8Array;
    readonly qop: number;
    readonly service: Nfsv4RpcSecGssService;
    constructor(oid: Uint8Array, qop: number, service: Nfsv4RpcSecGssService);
}
export declare class Nfsv4SecInfoFlavor {
    readonly flavor: number;
    readonly flavorInfo?: Nfsv4RpcSecGssInfo | undefined;
    constructor(flavor: number, flavorInfo?: Nfsv4RpcSecGssInfo | undefined);
}
