import type { Nfsv4Stat, Nfsv4LockType } from './constants';
import type * as structs from './structs';
export type Nfsv4Operation = Nfsv4Request | Nfsv4Response;
export type Nfsv4Request = Nfsv4AccessRequest | Nfsv4CloseRequest | Nfsv4CommitRequest | Nfsv4CreateRequest | Nfsv4DelegpurgeRequest | Nfsv4DelegreturnRequest | Nfsv4GetattrRequest | Nfsv4GetfhRequest | Nfsv4LinkRequest | Nfsv4LockRequest | Nfsv4LocktRequest | Nfsv4LockuRequest | Nfsv4LookupRequest | Nfsv4LookuppRequest | Nfsv4NverifyRequest | Nfsv4OpenRequest | Nfsv4OpenattrRequest | Nfsv4OpenConfirmRequest | Nfsv4OpenDowngradeRequest | Nfsv4PutfhRequest | Nfsv4PutpubfhRequest | Nfsv4PutrootfhRequest | Nfsv4ReadRequest | Nfsv4ReaddirRequest | Nfsv4ReadlinkRequest | Nfsv4RemoveRequest | Nfsv4RenameRequest | Nfsv4RenewRequest | Nfsv4RestorefhRequest | Nfsv4SavefhRequest | Nfsv4SecinfoRequest | Nfsv4SetattrRequest | Nfsv4SetclientidRequest | Nfsv4SetclientidConfirmRequest | Nfsv4VerifyRequest | Nfsv4WriteRequest | Nfsv4ReleaseLockOwnerRequest | Nfsv4IllegalRequest;
export type Nfsv4Response = Nfsv4AccessResponse | Nfsv4CloseResponse | Nfsv4CommitResponse | Nfsv4CreateResponse | Nfsv4DelegpurgeResponse | Nfsv4DelegreturnResponse | Nfsv4GetattrResponse | Nfsv4GetfhResponse | Nfsv4LinkResponse | Nfsv4LockResponse | Nfsv4LocktResponse | Nfsv4LockuResponse | Nfsv4LookupResponse | Nfsv4LookuppResponse | Nfsv4NverifyResponse | Nfsv4OpenResponse | Nfsv4OpenattrResponse | Nfsv4OpenConfirmResponse | Nfsv4OpenDowngradeResponse | Nfsv4PutfhResponse | Nfsv4PutpubfhResponse | Nfsv4PutrootfhResponse | Nfsv4ReadResponse | Nfsv4ReaddirResponse | Nfsv4ReadlinkResponse | Nfsv4RemoveResponse | Nfsv4RenameResponse | Nfsv4RenewResponse | Nfsv4RestorefhResponse | Nfsv4SavefhResponse | Nfsv4SecinfoResponse | Nfsv4SetattrResponse | Nfsv4SetclientidResponse | Nfsv4SetclientidConfirmResponse | Nfsv4VerifyResponse | Nfsv4WriteResponse | Nfsv4ReleaseLockOwnerResponse | Nfsv4IllegalResponse;
export declare class Nfsv4AccessRequest {
    readonly access: number;
    constructor(access: number);
}
export declare class Nfsv4AccessResOk {
    readonly supported: number;
    readonly access: number;
    constructor(supported: number, access: number);
}
export declare class Nfsv4AccessResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4AccessResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4AccessResOk | undefined);
}
export declare class Nfsv4CloseRequest {
    readonly seqid: number;
    readonly openStateid: structs.Nfsv4Stateid;
    constructor(seqid: number, openStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4CloseResOk {
    readonly openStateid: structs.Nfsv4Stateid;
    constructor(openStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4CloseResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4CloseResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4CloseResOk | undefined);
}
export declare class Nfsv4CommitRequest {
    readonly offset: bigint;
    readonly count: number;
    constructor(offset: bigint, count: number);
}
export declare class Nfsv4CommitResOk {
    readonly writeverf: structs.Nfsv4Verifier;
    constructor(writeverf: structs.Nfsv4Verifier);
}
export declare class Nfsv4CommitResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4CommitResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4CommitResOk | undefined);
}
export declare class Nfsv4CreateRequest {
    readonly objtype: structs.Nfsv4CreateType;
    readonly objname: string;
    constructor(objtype: structs.Nfsv4CreateType, objname: string);
}
export declare class Nfsv4CreateResOk {
    readonly cinfo: structs.Nfsv4ChangeInfo;
    readonly attrset: structs.Nfsv4Bitmap;
    constructor(cinfo: structs.Nfsv4ChangeInfo, attrset: structs.Nfsv4Bitmap);
}
export declare class Nfsv4CreateResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4CreateResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4CreateResOk | undefined);
}
export declare class Nfsv4DelegpurgeRequest {
    readonly clientid: bigint;
    constructor(clientid: bigint);
}
export declare class Nfsv4DelegpurgeResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4DelegreturnRequest {
    readonly delegStateid: structs.Nfsv4Stateid;
    constructor(delegStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4DelegreturnResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4GetattrRequest {
    readonly attrRequest: structs.Nfsv4Bitmap;
    constructor(attrRequest: structs.Nfsv4Bitmap);
}
export declare class Nfsv4GetattrResOk {
    readonly objAttributes: structs.Nfsv4Fattr;
    constructor(objAttributes: structs.Nfsv4Fattr);
}
export declare class Nfsv4GetattrResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4GetattrResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4GetattrResOk | undefined);
}
export declare class Nfsv4GetfhRequest {
}
export declare class Nfsv4GetfhResOk {
    readonly object: structs.Nfsv4Fh;
    constructor(object: structs.Nfsv4Fh);
}
export declare class Nfsv4GetfhResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4GetfhResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4GetfhResOk | undefined);
}
export declare class Nfsv4LinkRequest {
    readonly newname: string;
    constructor(newname: string);
}
export declare class Nfsv4LinkResOk {
    readonly cinfo: structs.Nfsv4ChangeInfo;
    constructor(cinfo: structs.Nfsv4ChangeInfo);
}
export declare class Nfsv4LinkResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4LinkResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4LinkResOk | undefined);
}
export declare class Nfsv4LockRequest {
    readonly locktype: Nfsv4LockType;
    readonly reclaim: boolean;
    readonly offset: bigint;
    readonly length: bigint;
    readonly locker: structs.Nfsv4LockOwnerInfo;
    constructor(locktype: Nfsv4LockType, reclaim: boolean, offset: bigint, length: bigint, locker: structs.Nfsv4LockOwnerInfo);
}
export declare class Nfsv4LockResOk {
    readonly lockStateid: structs.Nfsv4Stateid;
    constructor(lockStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4LockResDenied {
    readonly offset: bigint;
    readonly length: bigint;
    readonly locktype: Nfsv4LockType;
    readonly owner: structs.Nfsv4LockOwner;
    constructor(offset: bigint, length: bigint, locktype: Nfsv4LockType, owner: structs.Nfsv4LockOwner);
}
export declare class Nfsv4LockResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4LockResOk | undefined;
    readonly denied?: Nfsv4LockResDenied | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4LockResOk | undefined, denied?: Nfsv4LockResDenied | undefined);
}
export declare class Nfsv4LocktRequest {
    readonly locktype: Nfsv4LockType;
    readonly offset: bigint;
    readonly length: bigint;
    readonly owner: structs.Nfsv4LockOwner;
    constructor(locktype: Nfsv4LockType, offset: bigint, length: bigint, owner: structs.Nfsv4LockOwner);
}
export declare class Nfsv4LocktResDenied {
    readonly offset: bigint;
    readonly length: bigint;
    readonly locktype: Nfsv4LockType;
    readonly owner: structs.Nfsv4LockOwner;
    constructor(offset: bigint, length: bigint, locktype: Nfsv4LockType, owner: structs.Nfsv4LockOwner);
}
export declare class Nfsv4LocktResponse {
    readonly status: Nfsv4Stat;
    readonly denied?: Nfsv4LocktResDenied | undefined;
    constructor(status: Nfsv4Stat, denied?: Nfsv4LocktResDenied | undefined);
}
export declare class Nfsv4LockuRequest {
    readonly locktype: Nfsv4LockType;
    readonly seqid: number;
    readonly lockStateid: structs.Nfsv4Stateid;
    readonly offset: bigint;
    readonly length: bigint;
    constructor(locktype: Nfsv4LockType, seqid: number, lockStateid: structs.Nfsv4Stateid, offset: bigint, length: bigint);
}
export declare class Nfsv4LockuResOk {
    readonly lockStateid: structs.Nfsv4Stateid;
    constructor(lockStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4LockuResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4LockuResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4LockuResOk | undefined);
}
export declare class Nfsv4LookupRequest {
    readonly objname: string;
    constructor(objname: string);
}
export declare class Nfsv4LookupResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4LookuppRequest {
}
export declare class Nfsv4LookuppResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4NverifyRequest {
    readonly objAttributes: structs.Nfsv4Fattr;
    constructor(objAttributes: structs.Nfsv4Fattr);
}
export declare class Nfsv4NverifyResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4OpenRequest {
    readonly seqid: number;
    readonly shareAccess: number;
    readonly shareDeny: number;
    readonly owner: structs.Nfsv4OpenOwner;
    readonly openhow: number;
    readonly claim: structs.Nfsv4OpenClaim;
    constructor(seqid: number, shareAccess: number, shareDeny: number, owner: structs.Nfsv4OpenOwner, openhow: number, claim: structs.Nfsv4OpenClaim);
}
export declare class Nfsv4OpenResOk {
    readonly stateid: structs.Nfsv4Stateid;
    readonly cinfo: structs.Nfsv4ChangeInfo;
    readonly rflags: number;
    readonly attrset: structs.Nfsv4Bitmap;
    readonly delegation: structs.Nfsv4OpenDelegation;
    constructor(stateid: structs.Nfsv4Stateid, cinfo: structs.Nfsv4ChangeInfo, rflags: number, attrset: structs.Nfsv4Bitmap, delegation: structs.Nfsv4OpenDelegation);
}
export declare class Nfsv4OpenResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4OpenResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4OpenResOk | undefined);
}
export declare class Nfsv4OpenattrRequest {
    readonly createdir: boolean;
    constructor(createdir: boolean);
}
export declare class Nfsv4OpenattrResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4OpenConfirmRequest {
    readonly openStateid: structs.Nfsv4Stateid;
    readonly seqid: number;
    constructor(openStateid: structs.Nfsv4Stateid, seqid: number);
}
export declare class Nfsv4OpenConfirmResOk {
    readonly openStateid: structs.Nfsv4Stateid;
    constructor(openStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4OpenConfirmResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4OpenConfirmResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4OpenConfirmResOk | undefined);
}
export declare class Nfsv4OpenDowngradeRequest {
    readonly openStateid: structs.Nfsv4Stateid;
    readonly seqid: number;
    readonly shareAccess: number;
    readonly shareDeny: number;
    constructor(openStateid: structs.Nfsv4Stateid, seqid: number, shareAccess: number, shareDeny: number);
}
export declare class Nfsv4OpenDowngradeResOk {
    readonly openStateid: structs.Nfsv4Stateid;
    constructor(openStateid: structs.Nfsv4Stateid);
}
export declare class Nfsv4OpenDowngradeResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4OpenDowngradeResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4OpenDowngradeResOk | undefined);
}
export declare class Nfsv4PutfhRequest {
    readonly object: structs.Nfsv4Fh;
    constructor(object: structs.Nfsv4Fh);
}
export declare class Nfsv4PutfhResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4PutpubfhRequest {
}
export declare class Nfsv4PutpubfhResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4PutrootfhRequest {
}
export declare class Nfsv4PutrootfhResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4ReadRequest {
    readonly stateid: structs.Nfsv4Stateid;
    readonly offset: bigint;
    readonly count: number;
    constructor(stateid: structs.Nfsv4Stateid, offset: bigint, count: number);
}
export declare class Nfsv4ReadResOk {
    readonly eof: boolean;
    readonly data: Uint8Array;
    constructor(eof: boolean, data: Uint8Array);
}
export declare class Nfsv4ReadResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4ReadResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4ReadResOk | undefined);
}
export declare class Nfsv4ReaddirRequest {
    readonly cookie: bigint;
    readonly cookieverf: structs.Nfsv4Verifier;
    readonly dircount: number;
    readonly maxcount: number;
    readonly attrRequest: structs.Nfsv4Bitmap;
    constructor(cookie: bigint, cookieverf: structs.Nfsv4Verifier, dircount: number, maxcount: number, attrRequest: structs.Nfsv4Bitmap);
}
export declare class Nfsv4ReaddirResOk {
    readonly cookieverf: structs.Nfsv4Verifier;
    readonly entries: structs.Nfsv4Entry[];
    readonly eof: boolean;
    constructor(cookieverf: structs.Nfsv4Verifier, entries: structs.Nfsv4Entry[], eof: boolean);
}
export declare class Nfsv4ReaddirResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4ReaddirResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4ReaddirResOk | undefined);
}
export declare class Nfsv4ReadlinkRequest {
}
export declare class Nfsv4ReadlinkResOk {
    readonly link: string;
    constructor(link: string);
}
export declare class Nfsv4ReadlinkResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4ReadlinkResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4ReadlinkResOk | undefined);
}
export declare class Nfsv4RemoveRequest {
    readonly target: string;
    constructor(target: string);
}
export declare class Nfsv4RemoveResOk {
    readonly cinfo: structs.Nfsv4ChangeInfo;
    constructor(cinfo: structs.Nfsv4ChangeInfo);
}
export declare class Nfsv4RemoveResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4RemoveResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4RemoveResOk | undefined);
}
export declare class Nfsv4RenameRequest {
    readonly oldname: string;
    readonly newname: string;
    constructor(oldname: string, newname: string);
}
export declare class Nfsv4RenameResOk {
    readonly sourceCinfo: structs.Nfsv4ChangeInfo;
    readonly targetCinfo: structs.Nfsv4ChangeInfo;
    constructor(sourceCinfo: structs.Nfsv4ChangeInfo, targetCinfo: structs.Nfsv4ChangeInfo);
}
export declare class Nfsv4RenameResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4RenameResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4RenameResOk | undefined);
}
export declare class Nfsv4RenewRequest {
    readonly clientid: bigint;
    constructor(clientid: bigint);
}
export declare class Nfsv4RenewResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4RestorefhRequest {
}
export declare class Nfsv4RestorefhResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4SavefhRequest {
}
export declare class Nfsv4SavefhResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4SecinfoRequest {
    readonly name: string;
    constructor(name: string);
}
export declare class Nfsv4SecinfoResOk {
    readonly flavors: structs.Nfsv4SecInfoFlavor[];
    constructor(flavors: structs.Nfsv4SecInfoFlavor[]);
}
export declare class Nfsv4SecinfoResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4SecinfoResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4SecinfoResOk | undefined);
}
export declare class Nfsv4SetattrRequest {
    readonly stateid: structs.Nfsv4Stateid;
    readonly objAttributes: structs.Nfsv4Fattr;
    constructor(stateid: structs.Nfsv4Stateid, objAttributes: structs.Nfsv4Fattr);
}
export declare class Nfsv4SetattrResOk {
    readonly attrsset: structs.Nfsv4Bitmap;
    constructor(attrsset: structs.Nfsv4Bitmap);
}
export declare class Nfsv4SetattrResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4SetattrResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4SetattrResOk | undefined);
}
export declare class Nfsv4SetclientidRequest {
    readonly client: structs.Nfsv4ClientId;
    readonly callback: structs.Nfsv4CbClient;
    readonly callbackIdent: number;
    constructor(client: structs.Nfsv4ClientId, callback: structs.Nfsv4CbClient, callbackIdent: number);
}
export declare class Nfsv4SetclientidResOk {
    readonly clientid: bigint;
    readonly setclientidConfirm: structs.Nfsv4Verifier;
    constructor(clientid: bigint, setclientidConfirm: structs.Nfsv4Verifier);
}
export declare class Nfsv4SetclientidResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4SetclientidResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4SetclientidResOk | undefined);
}
export declare class Nfsv4SetclientidConfirmRequest {
    readonly clientid: bigint;
    readonly setclientidConfirm: structs.Nfsv4Verifier;
    constructor(clientid: bigint, setclientidConfirm: structs.Nfsv4Verifier);
}
export declare class Nfsv4SetclientidConfirmResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4VerifyRequest {
    readonly objAttributes: structs.Nfsv4Fattr;
    constructor(objAttributes: structs.Nfsv4Fattr);
}
export declare class Nfsv4VerifyResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4WriteRequest {
    readonly stateid: structs.Nfsv4Stateid;
    readonly offset: bigint;
    readonly stable: number;
    readonly data: Uint8Array;
    constructor(stateid: structs.Nfsv4Stateid, offset: bigint, stable: number, data: Uint8Array);
}
export declare class Nfsv4WriteResOk {
    readonly count: number;
    readonly committed: number;
    readonly writeverf: structs.Nfsv4Verifier;
    constructor(count: number, committed: number, writeverf: structs.Nfsv4Verifier);
}
export declare class Nfsv4WriteResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4WriteResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4WriteResOk | undefined);
}
export declare class Nfsv4ReleaseLockOwnerRequest {
    readonly lockOwner: structs.Nfsv4LockOwner;
    constructor(lockOwner: structs.Nfsv4LockOwner);
}
export declare class Nfsv4ReleaseLockOwnerResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4IllegalRequest {
}
export declare class Nfsv4IllegalResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4CompoundRequest {
    readonly tag: string;
    readonly minorversion: number;
    readonly argarray: Nfsv4Request[];
    constructor(tag: string, minorversion: number, argarray: Nfsv4Request[]);
}
export declare class Nfsv4CompoundResponse {
    readonly status: Nfsv4Stat;
    readonly tag: string;
    readonly resarray: Nfsv4Response[];
    constructor(status: Nfsv4Stat, tag: string, resarray: Nfsv4Response[]);
}
export type Nfsv4CbOperation = Nfsv4CbRequest | Nfsv4CbResponse;
export type Nfsv4CbRequest = Nfsv4CbGetattrRequest | Nfsv4CbRecallRequest | Nfsv4CbIllegalRequest;
export type Nfsv4CbResponse = Nfsv4CbGetattrResponse | Nfsv4CbRecallResponse | Nfsv4CbIllegalResponse;
export declare class Nfsv4CbGetattrRequest {
    readonly fh: structs.Nfsv4Fh;
    readonly attrRequest: structs.Nfsv4Bitmap;
    constructor(fh: structs.Nfsv4Fh, attrRequest: structs.Nfsv4Bitmap);
}
export declare class Nfsv4CbGetattrResOk {
    readonly objAttributes: structs.Nfsv4Fattr;
    constructor(objAttributes: structs.Nfsv4Fattr);
}
export declare class Nfsv4CbGetattrResponse {
    readonly status: Nfsv4Stat;
    readonly resok?: Nfsv4CbGetattrResOk | undefined;
    constructor(status: Nfsv4Stat, resok?: Nfsv4CbGetattrResOk | undefined);
}
export declare class Nfsv4CbRecallRequest {
    readonly stateid: structs.Nfsv4Stateid;
    readonly truncate: boolean;
    readonly fh: structs.Nfsv4Fh;
    constructor(stateid: structs.Nfsv4Stateid, truncate: boolean, fh: structs.Nfsv4Fh);
}
export declare class Nfsv4CbRecallResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4CbIllegalRequest {
}
export declare class Nfsv4CbIllegalResponse {
    readonly status: Nfsv4Stat;
    constructor(status: Nfsv4Stat);
}
export declare class Nfsv4CbCompoundRequest {
    readonly tag: string;
    readonly minorversion: number;
    readonly callbackIdent: number;
    readonly argarray: Nfsv4CbRequest[];
    constructor(tag: string, minorversion: number, callbackIdent: number, argarray: Nfsv4CbRequest[]);
}
export declare class Nfsv4CbCompoundResponse {
    readonly status: Nfsv4Stat;
    readonly tag: string;
    readonly resarray: Nfsv4CbResponse[];
    constructor(status: Nfsv4Stat, tag: string, resarray: Nfsv4CbResponse[]);
}
