import { axe } from 'jest-axe';
import React from 'react';
import { composeStories } from '@storybook/testing-react';
import { render, screen } from '@testing-library/react';
import { defaultContext, TypeaheadContext, } from '../core/Context';
export { axe };
export * from '@storybook/testing-react';
export * from '@testing-library/react';
export { default as userEvent } from '@testing-library/user-event';
export function noop() { }
export function generateSnapshots(stories, { getElement = (wrapper) => wrapper.container.firstChild } = {}) {
    const composed = composeStories(stories);
    Object.entries(composed).forEach(([storyName, Story]) => {
        if (Story.parameters?.snapshot?.skip)
            return;
        test(`${storyName} story renders snapshot`, async () => {
            const view = render(React.createElement(Story, null));
            expect(await getElement(view)).toMatchSnapshot();
        });
    });
}
export const HintProvider = ({ children, ...context }) => {
    return (React.createElement(TypeaheadContext.Provider, { value: {
            ...defaultContext,
            ...context,
        } }, children));
};
export function getHint(container) {
    return container.getElementsByClassName('rbt-input-hint')[0];
}
export async function findInput(multiple = false) {
    const role = multiple ? 'textbox' : 'combobox';
    return screen.findByRole(role);
}
export function getInput() {
    return screen.getByRole('combobox');
}
export async function findItems() {
    return screen.findAllByRole('option');
}
export function getItems() {
    return screen.getAllByRole('option');
}
export async function findMenu() {
    return screen.findByRole('listbox');
}
export function getMenu() {
    return screen.queryByRole('listbox');
}
export async function findPaginator() {
    const items = await findItems();
    return items[items.length - 1];
}
export function getTokens(container) {
    return container.getElementsByClassName('rbt-token');
}
export async function waitForOverlay() {
    await findMenu();
}
