import React, { CSSProperties, ReactNode, Ref } from 'react';
import Typeahead from '../../core/Typeahead';
import { RenderMenuItemChildren, TypeaheadMenuProps } from '../TypeaheadMenu';
import { Align, Option, RenderToken, Size, TypeaheadInputProps, TypeaheadProps, TypeaheadManagerChildProps } from '../../types';
export interface RenderMenuProps extends Omit<TypeaheadMenuProps, 'labelKey' | 'options' | 'renderMenuItemChildren' | 'text'> {
    renderMenuItemChildren?: RenderMenuItemChildren;
}
export interface TypeaheadComponentProps extends Partial<TypeaheadProps> {
    align?: Align;
    className?: string;
    clearButton?: boolean;
    disabled?: boolean;
    dropup?: boolean;
    emptyLabel?: ReactNode;
    flip?: boolean;
    instanceRef?: Ref<Typeahead>;
    isInvalid?: boolean;
    isLoading?: boolean;
    isValid?: boolean;
    maxHeight?: string;
    newSelectionPrefix?: ReactNode;
    options: Option[];
    paginationText?: ReactNode;
    placeholder?: string;
    positionFixed?: boolean;
    renderInput?: (inputProps: TypeaheadInputProps, props: TypeaheadManagerChildProps) => JSX.Element;
    renderMenu?: (results: Option[], menuProps: RenderMenuProps, state: TypeaheadManagerChildProps) => JSX.Element;
    renderMenuItemChildren?: RenderMenuItemChildren;
    renderToken?: RenderToken;
    size?: Size;
    style?: CSSProperties;
}
declare const _default: React.ForwardRefExoticComponent<TypeaheadComponentProps & React.RefAttributes<Typeahead>>;
export default _default;
