"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapDoExpressionInIIFE = wrapDoExpressionInIIFE;
function wrapDoExpressionInIIFE(path) {
  const state = {
    break: new Set(),
    continue: new Set(),
    found: false
  };
  path.traverse({
    DoExpression(path) {
      const body = path.node.body.body;
      if (body.length) {
        path.replaceExpressionWithStatements(body);
      } else {
        path.replaceWith(path.scope.buildUndefinedNode());
      }
    },
    FunctionParent(path) {
      path.skip();
    },
    Loop() {
      state.break.add(null);
      state.continue.add(null);
    },
    LabeledStatement(path) {
      const name = path.node.label.name;
      state.break.add(name);
    },
    BreakStatement(path) {
      var _path$node$label$name, _path$node$label;
      if (!state.break.has((_path$node$label$name = (_path$node$label = path.node.label) == null ? void 0 : _path$node$label.name) != null ? _path$node$label$name : null)) {
        throwError(path);
      }
    },
    ContinueStatement(path) {
      var _path$node$label$name2, _path$node$label2;
      if (!state.continue.has((_path$node$label$name2 = (_path$node$label2 = path.node.label) == null ? void 0 : _path$node$label2.name) != null ? _path$node$label$name2 : null)) {
        throwError(path);
      }
    },
    ReturnStatement(path) {
      throwError(path);
    }
  });
  function throwError(path) {
    throw path.buildCodeFrameError("This control flow escape from do expression is not supported.");
  }
}

//# sourceMappingURL=utils.js.map
