/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ApiError from '../model/ApiError';
import AssetDirMapping from '../model/AssetDirMapping';
import Document from '../model/Document';
import DocumentPagedResult from '../model/DocumentPagedResult';
import PagedResult from '../model/PagedResult';

/**
* JansAssets service.
* @module api/JansAssetsApi
* @version OAS Version
*/
export default class JansAssetsApi {

    /**
    * Constructs a new JansAssetsApi. 
    * @alias module:api/JansAssetsApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteAsset operation.
     * @callback module:api/JansAssetsApi~deleteAssetCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete an asset
     * Delete an asset
     * @param {String} inum Asset identifier
     * @param {module:api/JansAssetsApi~deleteAssetCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteAsset(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteAsset");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/jans-assets/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAllAssets operation.
     * @callback module:api/JansAssetsApi~getAllAssetsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/DocumentPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets all Jans assets.
     * Gets all Jans assets.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {String} opts.status Status of the attribute (default to 'all')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/JansAssetsApi~getAllAssetsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/DocumentPagedResult}
     */
    getAllAssets(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'status': opts['status'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = DocumentPagedResult;
      return this.apiClient.callApi(
        '/api/v1/jans-assets', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAssetByInum operation.
     * @callback module:api/JansAssetsApi~getAssetByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an asset by inum - unique identifier
     * Gets an asset by inum - unique identifier
     * @param {String} inum Asset Inum
     * @param {module:api/JansAssetsApi~getAssetByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getAssetByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getAssetByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/jans-assets/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAssetByName operation.
     * @callback module:api/JansAssetsApi~getAssetByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/DocumentPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch asset by name
     * Fetch asset by name.
     * @param {String} name Asset Name
     * @param {module:api/JansAssetsApi~getAssetByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/DocumentPagedResult}
     */
    getAssetByName(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getAssetByName");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = DocumentPagedResult;
      return this.apiClient.callApi(
        '/api/v1/jans-assets/name/{name}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAssetDirMapping operation.
     * @callback module:api/JansAssetsApi~getAssetDirMappingCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AssetDirMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get valid asset types
     * Get valid asset types
     * @param {module:api/JansAssetsApi~getAssetDirMappingCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AssetDirMapping>}
     */
    getAssetDirMapping(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [AssetDirMapping];
      return this.apiClient.callApi(
        '/api/v1/jans-assets/asset-dir-mapping', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAssetServices operation.
     * @callback module:api/JansAssetsApi~getAssetServicesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets asset services
     * Gets asset services
     * @param {module:api/JansAssetsApi~getAssetServicesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
    getAssetServices(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ['String'];
      return this.apiClient.callApi(
        '/api/v1/jans-assets/services', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAssetTypes operation.
     * @callback module:api/JansAssetsApi~getAssetTypesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get valid asset types
     * Get valid asset types
     * @param {module:api/JansAssetsApi~getAssetTypesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
    getAssetTypes(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ['String'];
      return this.apiClient.callApi(
        '/api/v1/jans-assets/asset-type', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the loadServiceAsset operation.
     * @callback module:api/JansAssetsApi~loadServiceAssetCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Load assets on server for a service
     * Load assets on server for a service
     * @param {String} serviceName Service Name
     * @param {module:api/JansAssetsApi~loadServiceAssetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
    loadServiceAsset(serviceName, callback) {
      let postBody = null;
      // verify the required parameter 'serviceName' is set
      if (serviceName === undefined || serviceName === null) {
        throw new Error("Missing the required parameter 'serviceName' when calling loadServiceAsset");
      }

      let pathParams = {
        'service-name': serviceName
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json'];
      let returnType = 'String';
      return this.apiClient.callApi(
        '/api/v1/jans-assets/service/{service-name}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postNewAsset operation.
     * @callback module:api/JansAssetsApi~postNewAssetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Document} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Upload new asset
     * Upload new asset
     * @param {module:model/Document} document 
     * @param {File} assetFile 
     * @param {module:api/JansAssetsApi~postNewAssetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Document}
     */
    postNewAsset(document, assetFile, callback) {
      let postBody = null;
      // verify the required parameter 'document' is set
      if (document === undefined || document === null) {
        throw new Error("Missing the required parameter 'document' when calling postNewAsset");
      }
      // verify the required parameter 'assetFile' is set
      if (assetFile === undefined || assetFile === null) {
        throw new Error("Missing the required parameter 'assetFile' when calling postNewAsset");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
        'document': document,
        'assetFile': assetFile
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json-patch+json', 'application/json'];
      let returnType = Document;
      return this.apiClient.callApi(
        '/api/v1/jans-assets/upload', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putAsset operation.
     * @callback module:api/JansAssetsApi~putAssetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Document} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update existing asset
     * Update existing asset
     * @param {module:model/Document} document 
     * @param {File} assetFile 
     * @param {module:api/JansAssetsApi~putAssetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Document}
     */
    putAsset(document, assetFile, callback) {
      let postBody = null;
      // verify the required parameter 'document' is set
      if (document === undefined || document === null) {
        throw new Error("Missing the required parameter 'document' when calling putAsset");
      }
      // verify the required parameter 'assetFile' is set
      if (assetFile === undefined || assetFile === null) {
        throw new Error("Missing the required parameter 'assetFile' when calling putAsset");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
        'document': document,
        'assetFile': assetFile
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json-patch+json', 'application/json'];
      let returnType = Document;
      return this.apiClient.callApi(
        '/api/v1/jans-assets/upload', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
