# JansConfigApi.AttributeApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAttributesByInum**](AttributeApi.md#deleteAttributesByInum) | **DELETE** /api/v1/attributes/{inum} | Deletes an attribute based on inum
[**getAttributes**](AttributeApi.md#getAttributes) | **GET** /api/v1/attributes | Gets a list of Jans attributes.
[**getAttributesByInum**](AttributeApi.md#getAttributesByInum) | **GET** /api/v1/attributes/{inum} | Gets an attribute based on inum
[**patchAttributesByInum**](AttributeApi.md#patchAttributesByInum) | **PATCH** /api/v1/attributes/{inum} | Partially modify a JansAttribute
[**postAttributes**](AttributeApi.md#postAttributes) | **POST** /api/v1/attributes | Adds a new attribute
[**putAttributes**](AttributeApi.md#putAttributes) | **PUT** /api/v1/attributes | Updates an existing attribute



## deleteAttributesByInum

> deleteAttributesByInum(inum)

Deletes an attribute based on inum

Deletes an attribute based on inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AttributeApi();
let inum = "inum_example"; // String | Attribute Id
apiInstance.deleteAttributesByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Attribute Id | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getAttributes

> PagedResult getAttributes(opts)

Gets a list of Jans attributes.

Gets a list of Jans attributes.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AttributeApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'status': "'all'", // String | Status of the attribute
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': adminCanEdit=true,dataType=string // String | Field and value pair for seraching
};
apiInstance.getAttributes(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **status** | **String**| Status of the attribute | [optional] [default to &#39;all&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAttributesByInum

> JansAttribute getAttributesByInum(inum)

Gets an attribute based on inum

Gets an attribute based on inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AttributeApi();
let inum = "inum_example"; // String | Attribute Id
apiInstance.getAttributesByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Attribute Id | 

### Return type

[**JansAttribute**](JansAttribute.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchAttributesByInum

> JansAttribute patchAttributesByInum(inum, opts)

Partially modify a JansAttribute

Partially modify a JansAttribute

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AttributeApi();
let inum = "inum_example"; // String | Attribute Id
let opts = {
  'patchRequest': [ {op:replace, path: displayName, value: "CustomAttribute" } ]
 // [PatchRequest] | String representing patch-document.
};
apiInstance.patchAttributesByInum(inum, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Attribute Id | 
 **patchRequest** | [**[PatchRequest]**](PatchRequest.md)| String representing patch-document. | [optional] 

### Return type

[**JansAttribute**](JansAttribute.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postAttributes

> JansAttribute postAttributes(opts)

Adds a new attribute

Adds a new attribute

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AttributeApi();
let opts = {
  'jansAttribute': {
    "adminCanAccess": true,
    "adminCanEdit": true,
    "adminCanView": true,
    "custom": false,
    "dataType": "string",
    "description": "QAAdded Attribute",
    "displayName": "QAAdded Attribute",
    "editType": [
        "admin",
        "user"
    ],
    "name": "qaattribute",
    "origin": "jansPerson",
    "jansMultivaluedAttr": false,
    "status": "active",
    "urn": "urn:mace:dir:attribute-def:qaattribute",
    "userCanAccess": true,
    "userCanEdit": true,
    "userCanView": true,
    "viewType": [
        "admin",
        "user"
    ],
    "whitePagesCanView": false
}
 // JansAttribute | JansAttribute object
};
apiInstance.postAttributes(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **jansAttribute** | [**JansAttribute**](JansAttribute.md)| JansAttribute object | [optional] 

### Return type

[**JansAttribute**](JansAttribute.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putAttributes

> JansAttribute putAttributes(opts)

Updates an existing attribute

Updates an existing attribute

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AttributeApi();
let opts = {
  'jansAttribute': {
    "adminCanAccess": true,
    "adminCanEdit": true,
    "adminCanView": true,
    "custom": false,
    "dataType": "string",
    "description": "QAAdded Attribute",
    "displayName": "QAAdded Attribute",
    "editType": [
        "admin",
        "user"
    ],
    "name": "qaattribute",
    "origin": "jansPerson",
    "jansMultivaluedAttr": false,
    "status": "active",
    "urn": "urn:mace:dir:attribute-def:qaattribute",
    "userCanAccess": true,
    "userCanEdit": true,
    "userCanView": true,
    "viewType": [
        "admin",
        "user"
    ],
    "whitePagesCanView": false
}
 // JansAttribute | JansAttribute object
};
apiInstance.putAttributes(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **jansAttribute** | [**JansAttribute**](JansAttribute.md)| JansAttribute object | [optional] 

### Return type

[**JansAttribute**](JansAttribute.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

