"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The SamlAppConfiguration model module.
 * @module model/SamlAppConfiguration
 * @version OAS Version
 */
var SamlAppConfiguration = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>SamlAppConfiguration</code>.
   * @alias module:model/SamlAppConfiguration
   */
  function SamlAppConfiguration() {
    _classCallCheck(this, SamlAppConfiguration);
    SamlAppConfiguration.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(SamlAppConfiguration, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>SamlAppConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SamlAppConfiguration} obj Optional instance to populate.
     * @return {module:model/SamlAppConfiguration} The populated <code>SamlAppConfiguration</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new SamlAppConfiguration();
        if (data.hasOwnProperty('applicationName')) {
          obj['applicationName'] = _ApiClient["default"].convertToType(data['applicationName'], 'String');
        }
        if (data.hasOwnProperty('samlTrustRelationshipDn')) {
          obj['samlTrustRelationshipDn'] = _ApiClient["default"].convertToType(data['samlTrustRelationshipDn'], 'String');
        }
        if (data.hasOwnProperty('trustedIdpDn')) {
          obj['trustedIdpDn'] = _ApiClient["default"].convertToType(data['trustedIdpDn'], 'String');
        }
        if (data.hasOwnProperty('enabled')) {
          obj['enabled'] = _ApiClient["default"].convertToType(data['enabled'], 'Boolean');
        }
        if (data.hasOwnProperty('selectedIdp')) {
          obj['selectedIdp'] = _ApiClient["default"].convertToType(data['selectedIdp'], 'String');
        }
        if (data.hasOwnProperty('serverUrl')) {
          obj['serverUrl'] = _ApiClient["default"].convertToType(data['serverUrl'], 'String');
        }
        if (data.hasOwnProperty('realm')) {
          obj['realm'] = _ApiClient["default"].convertToType(data['realm'], 'String');
        }
        if (data.hasOwnProperty('clientId')) {
          obj['clientId'] = _ApiClient["default"].convertToType(data['clientId'], 'String');
        }
        if (data.hasOwnProperty('clientSecret')) {
          obj['clientSecret'] = _ApiClient["default"].convertToType(data['clientSecret'], 'String');
        }
        if (data.hasOwnProperty('grantType')) {
          obj['grantType'] = _ApiClient["default"].convertToType(data['grantType'], 'String');
        }
        if (data.hasOwnProperty('scope')) {
          obj['scope'] = _ApiClient["default"].convertToType(data['scope'], 'String');
        }
        if (data.hasOwnProperty('username')) {
          obj['username'] = _ApiClient["default"].convertToType(data['username'], 'String');
        }
        if (data.hasOwnProperty('password')) {
          obj['password'] = _ApiClient["default"].convertToType(data['password'], 'String');
        }
        if (data.hasOwnProperty('spMetadataUrl')) {
          obj['spMetadataUrl'] = _ApiClient["default"].convertToType(data['spMetadataUrl'], 'String');
        }
        if (data.hasOwnProperty('tokenUrl')) {
          obj['tokenUrl'] = _ApiClient["default"].convertToType(data['tokenUrl'], 'String');
        }
        if (data.hasOwnProperty('idpUrl')) {
          obj['idpUrl'] = _ApiClient["default"].convertToType(data['idpUrl'], 'String');
        }
        if (data.hasOwnProperty('extIDPTokenUrl')) {
          obj['extIDPTokenUrl'] = _ApiClient["default"].convertToType(data['extIDPTokenUrl'], 'String');
        }
        if (data.hasOwnProperty('extIDPRedirectUrl')) {
          obj['extIDPRedirectUrl'] = _ApiClient["default"].convertToType(data['extIDPRedirectUrl'], 'String');
        }
        if (data.hasOwnProperty('idpMetadataImportUrl')) {
          obj['idpMetadataImportUrl'] = _ApiClient["default"].convertToType(data['idpMetadataImportUrl'], 'String');
        }
        if (data.hasOwnProperty('idpRootDir')) {
          obj['idpRootDir'] = _ApiClient["default"].convertToType(data['idpRootDir'], 'String');
        }
        if (data.hasOwnProperty('idpMetadataDir')) {
          obj['idpMetadataDir'] = _ApiClient["default"].convertToType(data['idpMetadataDir'], 'String');
        }
        if (data.hasOwnProperty('idpMetadataTempDir')) {
          obj['idpMetadataTempDir'] = _ApiClient["default"].convertToType(data['idpMetadataTempDir'], 'String');
        }
        if (data.hasOwnProperty('idpMetadataFile')) {
          obj['idpMetadataFile'] = _ApiClient["default"].convertToType(data['idpMetadataFile'], 'String');
        }
        if (data.hasOwnProperty('spMetadataDir')) {
          obj['spMetadataDir'] = _ApiClient["default"].convertToType(data['spMetadataDir'], 'String');
        }
        if (data.hasOwnProperty('spMetadataTempDir')) {
          obj['spMetadataTempDir'] = _ApiClient["default"].convertToType(data['spMetadataTempDir'], 'String');
        }
        if (data.hasOwnProperty('spMetadataFile')) {
          obj['spMetadataFile'] = _ApiClient["default"].convertToType(data['spMetadataFile'], 'String');
        }
        if (data.hasOwnProperty('ignoreValidation')) {
          obj['ignoreValidation'] = _ApiClient["default"].convertToType(data['ignoreValidation'], 'Boolean');
        }
        if (data.hasOwnProperty('setConfigDefaultValue')) {
          obj['setConfigDefaultValue'] = _ApiClient["default"].convertToType(data['setConfigDefaultValue'], 'Boolean');
        }
        if (data.hasOwnProperty('idpMetadataMandatoryAttributes')) {
          obj['idpMetadataMandatoryAttributes'] = _ApiClient["default"].convertToType(data['idpMetadataMandatoryAttributes'], ['String']);
        }
        if (data.hasOwnProperty('kcAttributes')) {
          obj['kcAttributes'] = _ApiClient["default"].convertToType(data['kcAttributes'], ['String']);
        }
        if (data.hasOwnProperty('kcSamlConfig')) {
          obj['kcSamlConfig'] = _ApiClient["default"].convertToType(data['kcSamlConfig'], ['String']);
        }
      }
      return obj;
    }
  }]);
}();
/**
 * Name of application.
 * @member {String} applicationName
 */
SamlAppConfiguration.prototype['applicationName'] = undefined;

/**
 * Trust relationship organizational unit.
 * @member {String} samlTrustRelationshipDn
 */
SamlAppConfiguration.prototype['samlTrustRelationshipDn'] = undefined;

/**
 * Identity provider organizational unit.
 * @member {String} trustedIdpDn
 */
SamlAppConfiguration.prototype['trustedIdpDn'] = undefined;

/**
 * SAML functionality enabled.
 * @member {Boolean} enabled
 */
SamlAppConfiguration.prototype['enabled'] = undefined;

/**
 * Selected SAML server.
 * @member {String} selectedIdp
 */
SamlAppConfiguration.prototype['selectedIdp'] = undefined;

/**
 * SAML server URL.
 * @member {String} serverUrl
 */
SamlAppConfiguration.prototype['serverUrl'] = undefined;

/**
 * SAML server realm, default is `jans`.
 * @member {String} realm
 */
SamlAppConfiguration.prototype['realm'] = undefined;

/**
 * Jans auth SAML client ID.
 * @member {String} clientId
 */
SamlAppConfiguration.prototype['clientId'] = undefined;

/**
 * Jans auth SAML client password.
 * @member {String} clientSecret
 */
SamlAppConfiguration.prototype['clientSecret'] = undefined;

/**
 * Grant type to get access token.
 * @member {String} grantType
 */
SamlAppConfiguration.prototype['grantType'] = undefined;

/**
 * Oauth2 scope to get access token.
 * @member {String} scope
 */
SamlAppConfiguration.prototype['scope'] = undefined;

/**
 * SAML server username.
 * @member {String} username
 */
SamlAppConfiguration.prototype['username'] = undefined;

/**
 * SAML server user credentails.
 * @member {String} password
 */
SamlAppConfiguration.prototype['password'] = undefined;

/**
 * Relative SAML server SP Metadata Url.
 * @member {String} spMetadataUrl
 */
SamlAppConfiguration.prototype['spMetadataUrl'] = undefined;

/**
 * Relative SAML server Token Url.
 * @member {String} tokenUrl
 */
SamlAppConfiguration.prototype['tokenUrl'] = undefined;

/**
 * Relative SAML server IDP Url.
 * @member {String} idpUrl
 */
SamlAppConfiguration.prototype['idpUrl'] = undefined;

/**
 * Relative SAML server IDP Token Url.
 * @member {String} extIDPTokenUrl
 */
SamlAppConfiguration.prototype['extIDPTokenUrl'] = undefined;

/**
 * Relative IDP redirect Url.
 * @member {String} extIDPRedirectUrl
 */
SamlAppConfiguration.prototype['extIDPRedirectUrl'] = undefined;

/**
 * Relative SAML server Metadata import Url.
 * @member {String} idpMetadataImportUrl
 */
SamlAppConfiguration.prototype['idpMetadataImportUrl'] = undefined;

/**
 * Jans Auth server root SAML directory.
 * @member {String} idpRootDir
 */
SamlAppConfiguration.prototype['idpRootDir'] = undefined;

/**
 * Jans Auth server relative SAML directory to store IDP Metadata files.
 * @member {String} idpMetadataDir
 */
SamlAppConfiguration.prototype['idpMetadataDir'] = undefined;

/**
 * Jans Auth server relative SAML temp directory to store IDP Metadata files.
 * @member {String} idpMetadataTempDir
 */
SamlAppConfiguration.prototype['idpMetadataTempDir'] = undefined;

/**
 * IDP Metadata file name format.
 * @member {String} idpMetadataFile
 */
SamlAppConfiguration.prototype['idpMetadataFile'] = undefined;

/**
 * Jans Auth server relative SAML directory to store SP Metadata files.
 * @member {String} spMetadataDir
 */
SamlAppConfiguration.prototype['spMetadataDir'] = undefined;

/**
 * Jans Auth server relative SAML temp directory to store SP Metadata files.
 * @member {String} spMetadataTempDir
 */
SamlAppConfiguration.prototype['spMetadataTempDir'] = undefined;

/**
 * SP Metadata file name format.
 * @member {String} spMetadataFile
 */
SamlAppConfiguration.prototype['spMetadataFile'] = undefined;

/**
 * Boolean value to enable/disable SAML validation.
 * @member {Boolean} ignoreValidation
 */
SamlAppConfiguration.prototype['ignoreValidation'] = undefined;

/**
 * Boolean value `true` to set the default values for an IDP.
 * @member {Boolean} setConfigDefaultValue
 */
SamlAppConfiguration.prototype['setConfigDefaultValue'] = undefined;

/**
 * List of mandatory IDP Metadata attributes.
 * @member {Array.<String>} idpMetadataMandatoryAttributes
 */
SamlAppConfiguration.prototype['idpMetadataMandatoryAttributes'] = undefined;

/**
 * Keycloak SAML attribute names.
 * @member {Array.<String>} kcAttributes
 */
SamlAppConfiguration.prototype['kcAttributes'] = undefined;

/**
 * Keycloak SAML config attribute names.
 * @member {Array.<String>} kcSamlConfig
 */
SamlAppConfiguration.prototype['kcSamlConfig'] = undefined;
var _default = exports["default"] = SamlAppConfiguration;