"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _TokenEntity = _interopRequireDefault(require("../model/TokenEntity"));
var _TokenEntityPagedResult = _interopRequireDefault(require("../model/TokenEntityPagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* Token service.
* @module api/TokenApi
* @version OAS Version
*/
var TokenApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new TokenApi. 
  * @alias module:api/TokenApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function TokenApi(apiClient) {
    _classCallCheck(this, TokenApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the getTokenByClient operation.
   * @callback module:api/TokenApi~getTokenByClientCallback
   * @param {String} error Error message, if any.
   * @param {module:model/TokenEntityPagedResult} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Get token details by client.
   * Get token details by client.
   * @param {String} clientId Client identifier
   * @param {module:api/TokenApi~getTokenByClientCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link module:model/TokenEntityPagedResult}
   */
  return _createClass(TokenApi, [{
    key: "getTokenByClient",
    value: function getTokenByClient(clientId, callback) {
      var postBody = null;
      // verify the required parameter 'clientId' is set
      if (clientId === undefined || clientId === null) {
        throw new Error("Missing the required parameter 'clientId' when calling getTokenByClient");
      }
      var pathParams = {
        'clientId': clientId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _TokenEntityPagedResult["default"];
      return this.apiClient.callApi('/api/v1/token/client/{clientId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getTokenById operation.
     * @callback module:api/TokenApi~getTokenByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TokenEntity} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get token details by Id.
     * Get token details by Id.
     * @param {String} tknCde Token identifier
     * @param {module:api/TokenApi~getTokenByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TokenEntity}
     */
  }, {
    key: "getTokenById",
    value: function getTokenById(tknCde, callback) {
      var postBody = null;
      // verify the required parameter 'tknCde' is set
      if (tknCde === undefined || tknCde === null) {
        throw new Error("Missing the required parameter 'tknCde' when calling getTokenById");
      }
      var pathParams = {
        'tknCde': tknCde
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _TokenEntity["default"];
      return this.apiClient.callApi('/api/v1/token/tknCde/{tknCde}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the revokeToken operation.
     * @callback module:api/TokenApi~revokeTokenCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Revoke client token.
     * Revoke client token.
     * @param {String} tknCde Token Code
     * @param {module:api/TokenApi~revokeTokenCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "revokeToken",
    value: function revokeToken(tknCde, callback) {
      var postBody = null;
      // verify the required parameter 'tknCde' is set
      if (tknCde === undefined || tknCde === null) {
        throw new Error("Missing the required parameter 'tknCde' when calling revokeToken");
      }
      var pathParams = {
        'tknCde': tknCde
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/token/revoke/{tknCde}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the searchToken operation.
     * @callback module:api/TokenApi~searchTokenCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TokenEntityPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Search tokens
     * Search tokens
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'tknCde')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/TokenApi~searchTokenCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TokenEntityPagedResult}
     */
  }, {
    key: "searchToken",
    value: function searchToken(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _TokenEntityPagedResult["default"];
      return this.apiClient.callApi('/api/v1/token/search', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();