# jans_config_api

JansConfigApi - JavaScript client for jans_config_api
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: OAS Version
- Package version: OAS Version
- Build package: org.openapitools.codegen.languages.JavascriptClientCodegen
For more information, please visit [https://github.com/JanssenProject/jans/discussions](https://github.com/JanssenProject/jans/discussions)

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/), please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install jans_config_api --save
```

Finally, you need to build the module:

```shell
npm run build
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

To use the link you just defined in your project, switch to the directory you want to use your jans_config_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

Finally, you need to build the module:

```shell
npm run build
```

#### git

If the library is hosted at a git repository, e.g.https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var JansConfigApi = require('jans_config_api');

var defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
var oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = "YOUR ACCESS TOKEN"

var api = new JansConfigApi.AdminUIConfigurationApi()
var opts = {
  'appConfigResponse': new JansConfigApi.AppConfigResponse() // {AppConfigResponse} Admin Config object
};
var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.editAdminuiConf(opts, callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://jans.local.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*JansConfigApi.AdminUIConfigurationApi* | [**editAdminuiConf**](docs/AdminUIConfigurationApi.md#editAdminuiConf) | **PUT** /admin-ui/config | Edit Admin UI editable configuration
*JansConfigApi.AdminUIConfigurationApi* | [**getAdminuiConf**](docs/AdminUIConfigurationApi.md#getAdminuiConf) | **GET** /admin-ui/config | Get Admin UI editable configuration
*JansConfigApi.AdminUILicenseApi* | [**activateAdminuiLicense**](docs/AdminUILicenseApi.md#activateAdminuiLicense) | **POST** /admin-ui/license/activate | Activate license using license-key
*JansConfigApi.AdminUILicenseApi* | [**adminuiPostSsa**](docs/AdminUILicenseApi.md#adminuiPostSsa) | **POST** /admin-ui/license/ssa | Save SSA in configuration
*JansConfigApi.AdminUILicenseApi* | [**checkAdminuiLicenseConfig**](docs/AdminUILicenseApi.md#checkAdminuiLicenseConfig) | **GET** /admin-ui/license/isConfigValid | Is license configuration valid
*JansConfigApi.AdminUILicenseApi* | [**getAdminuiLicense**](docs/AdminUILicenseApi.md#getAdminuiLicense) | **GET** /admin-ui/license/details | Get admin ui license details
*JansConfigApi.AdminUILicenseApi* | [**getTrialLicense**](docs/AdminUILicenseApi.md#getTrialLicense) | **GET** /admin-ui/license/trial | Generate trial license
*JansConfigApi.AdminUILicenseApi* | [**isLicenseActive**](docs/AdminUILicenseApi.md#isLicenseActive) | **GET** /admin-ui/license/isActive | Check if admin-ui license is active
*JansConfigApi.AdminUILicenseApi* | [**licenseConfigDelete**](docs/AdminUILicenseApi.md#licenseConfigDelete) | **DELETE** /admin-ui/license/deleteConfig | Delete license details in admin-ui configuration
*JansConfigApi.AdminUILicenseApi* | [**retrieveLicense**](docs/AdminUILicenseApi.md#retrieveLicense) | **GET** /admin-ui/license/retrieve | Retrieve license from SCAN
*JansConfigApi.AdminUIPermissionApi* | [**addAdminuiPermission**](docs/AdminUIPermissionApi.md#addAdminuiPermission) | **POST** /admin-ui/adminUIPermissions | Add admin ui permissions
*JansConfigApi.AdminUIPermissionApi* | [**deleteAdminuiPermission**](docs/AdminUIPermissionApi.md#deleteAdminuiPermission) | **DELETE** /admin-ui/adminUIPermissions/{adminUIPermission} | Delete admin ui permission by permission-name
*JansConfigApi.AdminUIPermissionApi* | [**editAdminuiPermission**](docs/AdminUIPermissionApi.md#editAdminuiPermission) | **PUT** /admin-ui/adminUIPermissions | Edit admin ui permissions
*JansConfigApi.AdminUIPermissionApi* | [**getAdminuiPermission**](docs/AdminUIPermissionApi.md#getAdminuiPermission) | **GET** /admin-ui/adminUIPermissions/{adminUIPermission} | Get admin ui permission by permission-name
*JansConfigApi.AdminUIPermissionApi* | [**getAllAdminuiPermissions**](docs/AdminUIPermissionApi.md#getAllAdminuiPermissions) | **GET** /admin-ui/adminUIPermissions | Get all admin ui permissions
*JansConfigApi.AdminUIRoleApi* | [**addAdminuiRole**](docs/AdminUIRoleApi.md#addAdminuiRole) | **POST** /admin-ui/adminUIRoles | Add admin ui role
*JansConfigApi.AdminUIRoleApi* | [**deleteAdminuiRole**](docs/AdminUIRoleApi.md#deleteAdminuiRole) | **DELETE** /admin-ui/adminUIRoles/{adminUIRole} | Delete admin ui role by role-name
*JansConfigApi.AdminUIRoleApi* | [**editAdminuiRole**](docs/AdminUIRoleApi.md#editAdminuiRole) | **PUT** /admin-ui/adminUIRoles | Edit admin ui role
*JansConfigApi.AdminUIRoleApi* | [**getAdminuiRole**](docs/AdminUIRoleApi.md#getAdminuiRole) | **GET** /admin-ui/adminUIRoles/{adminUIRole} | Get admin ui role details by role-name
*JansConfigApi.AdminUIRoleApi* | [**getAllAdminuiRoles**](docs/AdminUIRoleApi.md#getAllAdminuiRoles) | **GET** /admin-ui/adminUIRoles | Get all admin ui roles
*JansConfigApi.AdminUIRolePermissionsMappingApi* | [**addRolePermissionsMapping**](docs/AdminUIRolePermissionsMappingApi.md#addRolePermissionsMapping) | **POST** /admin-ui/adminUIRolePermissionsMapping | Add role-permissions mapping
*JansConfigApi.AdminUIRolePermissionsMappingApi* | [**getAdminuiRolePermissions**](docs/AdminUIRolePermissionsMappingApi.md#getAdminuiRolePermissions) | **GET** /admin-ui/adminUIRolePermissionsMapping/{adminUIRole} | Get admin ui role-permissions mapping by role-name
*JansConfigApi.AdminUIRolePermissionsMappingApi* | [**getAllAdminuiRolePermissions**](docs/AdminUIRolePermissionsMappingApi.md#getAllAdminuiRolePermissions) | **GET** /admin-ui/adminUIRolePermissionsMapping | Get all admin ui role-permissions mapping
*JansConfigApi.AdminUIRolePermissionsMappingApi* | [**mapPermissionsToRole**](docs/AdminUIRolePermissionsMappingApi.md#mapPermissionsToRole) | **PUT** /admin-ui/adminUIRolePermissionsMapping | Map permissions to role
*JansConfigApi.AdminUIRolePermissionsMappingApi* | [**removeRolePermissionsPermission**](docs/AdminUIRolePermissionsMappingApi.md#removeRolePermissionsPermission) | **DELETE** /admin-ui/adminUIRolePermissionsMapping/{adminUIRole} | Remove role-permissions mapping by role-name
*JansConfigApi.AdminUIWebhooksApi* | [**deleteWebhookByInum**](docs/AdminUIWebhooksApi.md#deleteWebhookByInum) | **DELETE** /admin-ui/webhook/{webhookId} | Delete Webhook
*JansConfigApi.AdminUIWebhooksApi* | [**getAllFeatures**](docs/AdminUIWebhooksApi.md#getAllFeatures) | **GET** /admin-ui/webhook/features | Gets list of Admin UI features
*JansConfigApi.AdminUIWebhooksApi* | [**getAllWebhooks**](docs/AdminUIWebhooksApi.md#getAllWebhooks) | **GET** /admin-ui/webhook | Gets list of webhooks
*JansConfigApi.AdminUIWebhooksApi* | [**getFeaturesByWebhookId**](docs/AdminUIWebhooksApi.md#getFeaturesByWebhookId) | **GET** /admin-ui/webhook/features/{webhookId} | Gets list of Admin UI features mapped to webhookId
*JansConfigApi.AdminUIWebhooksApi* | [**getWebhooksByFeatureId**](docs/AdminUIWebhooksApi.md#getWebhooksByFeatureId) | **GET** /admin-ui/webhook/{featureId} | Gets list of Admin UI Webhooks mapped to featureId
*JansConfigApi.AdminUIWebhooksApi* | [**postWebhook**](docs/AdminUIWebhooksApi.md#postWebhook) | **POST** /admin-ui/webhook | Create Webhook
*JansConfigApi.AdminUIWebhooksApi* | [**putWebhook**](docs/AdminUIWebhooksApi.md#putWebhook) | **PUT** /admin-ui/webhook | Update Webhook
*JansConfigApi.AdminUIWebhooksApi* | [**triggerWebhook**](docs/AdminUIWebhooksApi.md#triggerWebhook) | **POST** /admin-ui/webhook/trigger/{featureId} | Trigger webhooks mapped to featureId
*JansConfigApi.AgamaApi* | [**deleteAgamaPrj**](docs/AgamaApi.md#deleteAgamaPrj) | **DELETE** /api/v1/agama-deployment/{name} | Delete a deployed Agama project.
*JansConfigApi.AgamaApi* | [**getAgamaPrj**](docs/AgamaApi.md#getAgamaPrj) | **GET** /api/v1/agama-deployment | Retrieve the list of projects deployed currently.
*JansConfigApi.AgamaApi* | [**getAgamaPrjByName**](docs/AgamaApi.md#getAgamaPrjByName) | **GET** /api/v1/agama-deployment/{name} | Fetches deployed Agama project based on name.
*JansConfigApi.AgamaApi* | [**getAgamaPrjConfigs**](docs/AgamaApi.md#getAgamaPrjConfigs) | **GET** /api/v1/agama-deployment/configs/{name} | Retrieve the list of configs based on name.
*JansConfigApi.AgamaApi* | [**getAgamaProject**](docs/AgamaApi.md#getAgamaProject) | **GET** /api/v1/agama-repo/download | Download agama project.
*JansConfigApi.AgamaApi* | [**getAgamaRepositories**](docs/AgamaApi.md#getAgamaRepositories) | **GET** /api/v1/agama-repo | Gets all agama repositories.
*JansConfigApi.AgamaApi* | [**postAgamaPrj**](docs/AgamaApi.md#postAgamaPrj) | **POST** /api/v1/agama-deployment/{name} | Deploy an Agama project.
*JansConfigApi.AgamaApi* | [**putAgamaPrj**](docs/AgamaApi.md#putAgamaPrj) | **PUT** /api/v1/agama-deployment/configs/{name} | Update an Agama project.
*JansConfigApi.AgamaConfigurationApi* | [**agamaSyntaxCheck**](docs/AgamaConfigurationApi.md#agamaSyntaxCheck) | **POST** /api/v1/agama/syntax-check/{qname} | Determine if the text passed is valid Agama code
*JansConfigApi.AttributeApi* | [**deleteAttributesByInum**](docs/AttributeApi.md#deleteAttributesByInum) | **DELETE** /api/v1/attributes/{inum} | Deletes an attribute based on inum
*JansConfigApi.AttributeApi* | [**getAttributes**](docs/AttributeApi.md#getAttributes) | **GET** /api/v1/attributes | Gets a list of Jans attributes.
*JansConfigApi.AttributeApi* | [**getAttributesByInum**](docs/AttributeApi.md#getAttributesByInum) | **GET** /api/v1/attributes/{inum} | Gets an attribute based on inum
*JansConfigApi.AttributeApi* | [**patchAttributesByInum**](docs/AttributeApi.md#patchAttributesByInum) | **PATCH** /api/v1/attributes/{inum} | Partially modify a JansAttribute
*JansConfigApi.AttributeApi* | [**postAttributes**](docs/AttributeApi.md#postAttributes) | **POST** /api/v1/attributes | Adds a new attribute
*JansConfigApi.AttributeApi* | [**putAttributes**](docs/AttributeApi.md#putAttributes) | **PUT** /api/v1/attributes | Updates an existing attribute
*JansConfigApi.AuthServerHealthCheckApi* | [**getAuthServerHealth**](docs/AuthServerHealthCheckApi.md#getAuthServerHealth) | **GET** /api/v1/jans-auth-server/health | Returns auth server health status
*JansConfigApi.AuthSessionManagementApi* | [**deleteSession**](docs/AuthSessionManagementApi.md#deleteSession) | **DELETE** /api/v1/jans-auth-server/session/sid/{sid} | Delete a session.
*JansConfigApi.AuthSessionManagementApi* | [**getSessionById**](docs/AuthSessionManagementApi.md#getSessionById) | **GET** /api/v1/jans-auth-server/session/sid/{sid} | Get session by id.
*JansConfigApi.AuthSessionManagementApi* | [**getSessions**](docs/AuthSessionManagementApi.md#getSessions) | **GET** /api/v1/jans-auth-server/session | Return all session
*JansConfigApi.AuthSessionManagementApi* | [**revokeUserSession**](docs/AuthSessionManagementApi.md#revokeUserSession) | **DELETE** /api/v1/jans-auth-server/session/user/{userDn} | Revoke all sessions by userDn
*JansConfigApi.AuthSessionManagementApi* | [**searchSession**](docs/AuthSessionManagementApi.md#searchSession) | **GET** /api/v1/jans-auth-server/session/search | Search session
*JansConfigApi.CacheConfigurationApi* | [**getConfigCache**](docs/CacheConfigurationApi.md#getConfigCache) | **GET** /api/v1/config/cache | Returns cache configuration.
*JansConfigApi.CacheConfigurationApi* | [**patchConfigCache**](docs/CacheConfigurationApi.md#patchConfigCache) | **PATCH** /api/v1/config/cache | Patch cache configuration.
*JansConfigApi.CacheConfigurationInMemoryApi* | [**getConfigCacheInMemory**](docs/CacheConfigurationInMemoryApi.md#getConfigCacheInMemory) | **GET** /api/v1/config/cache/in-memory | Returns in-Memory cache configuration.
*JansConfigApi.CacheConfigurationInMemoryApi* | [**patchConfigCacheInMemory**](docs/CacheConfigurationInMemoryApi.md#patchConfigCacheInMemory) | **PATCH** /api/v1/config/cache/in-memory | Patch In-Memory cache configuration.
*JansConfigApi.CacheConfigurationInMemoryApi* | [**putConfigCacheInMemory**](docs/CacheConfigurationInMemoryApi.md#putConfigCacheInMemory) | **PUT** /api/v1/config/cache/in-memory | Updates in-Memory cache configuration.
*JansConfigApi.CacheConfigurationMemcachedApi* | [**getConfigCacheMemcached**](docs/CacheConfigurationMemcachedApi.md#getConfigCacheMemcached) | **GET** /api/v1/config/cache/memcached | Returns memcached cache configuration.
*JansConfigApi.CacheConfigurationMemcachedApi* | [**patchConfigCacheMemcached**](docs/CacheConfigurationMemcachedApi.md#patchConfigCacheMemcached) | **PATCH** /api/v1/config/cache/memcached | Patch memcached cache configuration.
*JansConfigApi.CacheConfigurationMemcachedApi* | [**putConfigCacheMemcached**](docs/CacheConfigurationMemcachedApi.md#putConfigCacheMemcached) | **PUT** /api/v1/config/cache/memcached | Updates memcached cache configuration.
*JansConfigApi.CacheConfigurationNativePersistenceApi* | [**getConfigCacheNativePersistence**](docs/CacheConfigurationNativePersistenceApi.md#getConfigCacheNativePersistence) | **GET** /api/v1/config/cache/native-persistence | Returns native persistence cache configuration.
*JansConfigApi.CacheConfigurationNativePersistenceApi* | [**patchConfigCacheNativePersistence**](docs/CacheConfigurationNativePersistenceApi.md#patchConfigCacheNativePersistence) | **PATCH** /api/v1/config/cache/native-persistence | Patch native persistence cache configuration.
*JansConfigApi.CacheConfigurationNativePersistenceApi* | [**putConfigCacheNativePersistence**](docs/CacheConfigurationNativePersistenceApi.md#putConfigCacheNativePersistence) | **PUT** /api/v1/config/cache/native-persistence | Updates native persistence cache configuration.
*JansConfigApi.CacheConfigurationRedisApi* | [**getConfigCacheRedis**](docs/CacheConfigurationRedisApi.md#getConfigCacheRedis) | **GET** /api/v1/config/cache/redis | Returns Redis cache configuration.
*JansConfigApi.CacheConfigurationRedisApi* | [**patchConfigCacheRedis**](docs/CacheConfigurationRedisApi.md#patchConfigCacheRedis) | **PATCH** /api/v1/config/cache/redis | Patch Redis cache configuration.
*JansConfigApi.CacheConfigurationRedisApi* | [**putConfigCacheRedis**](docs/CacheConfigurationRedisApi.md#putConfigCacheRedis) | **PUT** /api/v1/config/cache/redis | Updates Redis cache configuration.
*JansConfigApi.ClientAuthorizationApi* | [**deleteClientAuthorization**](docs/ClientAuthorizationApi.md#deleteClientAuthorization) | **DELETE** /api/v1/clients/authorizations/{userId}/{clientId}/{username} | Revoke client authorization
*JansConfigApi.ClientAuthorizationApi* | [**getClientAuthorization**](docs/ClientAuthorizationApi.md#getClientAuthorization) | **GET** /api/v1/clients/authorizations/{userId} | Gets list of client authorization
*JansConfigApi.ConfigurationConfigAPIApi* | [**getConfigApiProperties**](docs/ConfigurationConfigAPIApi.md#getConfigApiProperties) | **GET** /api/v1/api-config | Gets config-api configuration properties.
*JansConfigApi.ConfigurationConfigAPIApi* | [**patchConfigApiProperties**](docs/ConfigurationConfigAPIApi.md#patchConfigApiProperties) | **PATCH** /api/v1/api-config | Partially modifies config-api configuration properties.
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**deleteConfigJwkKid**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#deleteConfigJwkKid) | **DELETE** /api/v1/config/jwks/{kid} | Delete a JSON Web Key based on kid
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**getConfigJwks**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#getConfigJwks) | **GET** /api/v1/config/jwks | Gets list of JSON Web Key (JWK) used by server
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**getJwkByKid**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#getJwkByKid) | **GET** /api/v1/config/jwks/{kid} | Get a JSON Web Key based on kid
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**patchConfigJwkKid**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#patchConfigJwkKid) | **PATCH** /api/v1/config/jwks/{kid} | Patch a specific JSON Web Key based on kid
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**patchConfigJwks**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#patchConfigJwks) | **PATCH** /api/v1/config/jwks | Patches JSON Web Keys
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**postConfigJwksKey**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#postConfigJwksKey) | **POST** /api/v1/config/jwks/key | Configuration – JWK - JSON Web Key (JWK)
*JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi* | [**putConfigJwks**](docs/ConfigurationJWKJSONWebKeyJWKApi.md#putConfigJwks) | **PUT** /api/v1/config/jwks | Replaces JSON Web Keys
*JansConfigApi.ConfigurationLoggingApi* | [**getConfigLogging**](docs/ConfigurationLoggingApi.md#getConfigLogging) | **GET** /api/v1/logging | Returns Jans Authorization Server logging settings
*JansConfigApi.ConfigurationLoggingApi* | [**putConfigLogging**](docs/ConfigurationLoggingApi.md#putConfigLogging) | **PUT** /api/v1/logging | Updates Jans Authorization Server logging settings
*JansConfigApi.ConfigurationPropertiesApi* | [**getFeatureFlagType**](docs/ConfigurationPropertiesApi.md#getFeatureFlagType) | **GET** /api/v1/jans-auth-server/config/feature-flags | Returns feature flags type configured for Jans authorization server.
*JansConfigApi.ConfigurationPropertiesApi* | [**getProperties**](docs/ConfigurationPropertiesApi.md#getProperties) | **GET** /api/v1/jans-auth-server/config | Gets all Jans authorization server configuration properties.
*JansConfigApi.ConfigurationPropertiesApi* | [**getPropertiesPersistence**](docs/ConfigurationPropertiesApi.md#getPropertiesPersistence) | **GET** /api/v1/jans-auth-server/config/persistence | Returns persistence type configured for Jans authorization server.
*JansConfigApi.ConfigurationPropertiesApi* | [**patchProperties**](docs/ConfigurationPropertiesApi.md#patchProperties) | **PATCH** /api/v1/jans-auth-server/config | Partially modifies Jans authorization server Application configuration properties.
*JansConfigApi.ConfigurationSMTPApi* | [**deleteConfigSmtp**](docs/ConfigurationSMTPApi.md#deleteConfigSmtp) | **DELETE** /api/v1/config/smtp | Deletes SMTP server configuration
*JansConfigApi.ConfigurationSMTPApi* | [**getConfigSmtp**](docs/ConfigurationSMTPApi.md#getConfigSmtp) | **GET** /api/v1/config/smtp | Returns SMTP server configuration
*JansConfigApi.ConfigurationSMTPApi* | [**postConfigSmtp**](docs/ConfigurationSMTPApi.md#postConfigSmtp) | **POST** /api/v1/config/smtp | Adds SMTP server configuration
*JansConfigApi.ConfigurationSMTPApi* | [**putConfigSmtp**](docs/ConfigurationSMTPApi.md#putConfigSmtp) | **PUT** /api/v1/config/smtp | Updates SMTP server configuration
*JansConfigApi.ConfigurationSMTPApi* | [**testConfigSmtp**](docs/ConfigurationSMTPApi.md#testConfigSmtp) | **POST** /api/v1/config/smtp/test | Signing Test SMTP server configuration
*JansConfigApi.ConfigurationUserManagementApi* | [**deleteUser**](docs/ConfigurationUserManagementApi.md#deleteUser) | **DELETE** /mgt/configuser/{inum} | Delete User
*JansConfigApi.ConfigurationUserManagementApi* | [**getUser**](docs/ConfigurationUserManagementApi.md#getUser) | **GET** /mgt/configuser | Gets list of users
*JansConfigApi.ConfigurationUserManagementApi* | [**getUserByInum**](docs/ConfigurationUserManagementApi.md#getUserByInum) | **GET** /mgt/configuser/{inum} | Get User by Inum
*JansConfigApi.ConfigurationUserManagementApi* | [**patchUserByInum**](docs/ConfigurationUserManagementApi.md#patchUserByInum) | **PATCH** /mgt/configuser/{inum} | Patch user properties by Inum
*JansConfigApi.ConfigurationUserManagementApi* | [**postUser**](docs/ConfigurationUserManagementApi.md#postUser) | **POST** /mgt/configuser | Create new User
*JansConfigApi.ConfigurationUserManagementApi* | [**putUser**](docs/ConfigurationUserManagementApi.md#putUser) | **PUT** /mgt/configuser | Update User
*JansConfigApi.CustomScriptsApi* | [**deleteConfigScriptsByInum**](docs/CustomScriptsApi.md#deleteConfigScriptsByInum) | **DELETE** /api/v1/config/scripts/{inum} | Deletes a custom script
*JansConfigApi.CustomScriptsApi* | [**getConfigScripts**](docs/CustomScriptsApi.md#getConfigScripts) | **GET** /api/v1/config/scripts | Gets a list of custom scripts
*JansConfigApi.CustomScriptsApi* | [**getConfigScriptsByInum**](docs/CustomScriptsApi.md#getConfigScriptsByInum) | **GET** /api/v1/config/scripts/inum/{inum} | Gets a script by Inum
*JansConfigApi.CustomScriptsApi* | [**getConfigScriptsByType**](docs/CustomScriptsApi.md#getConfigScriptsByType) | **GET** /api/v1/config/scripts/type/{type} | Gets list of scripts by type
*JansConfigApi.CustomScriptsApi* | [**getCustomScriptByName**](docs/CustomScriptsApi.md#getCustomScriptByName) | **GET** /api/v1/config/scripts/name/{name} | Fetch custom script by name
*JansConfigApi.CustomScriptsApi* | [**getCustomScriptType**](docs/CustomScriptsApi.md#getCustomScriptType) | **GET** /api/v1/config/scripts/types | Fetch custom script types
*JansConfigApi.CustomScriptsApi* | [**getCustomScriptTypes**](docs/CustomScriptsApi.md#getCustomScriptTypes) | **GET** /api/v1/config/scripts/script-types | Fetch custom script types
*JansConfigApi.CustomScriptsApi* | [**patchConfigScriptsByInum**](docs/CustomScriptsApi.md#patchConfigScriptsByInum) | **PATCH** /api/v1/config/scripts/{inum} | Patches a custom script
*JansConfigApi.CustomScriptsApi* | [**postConfigScripts**](docs/CustomScriptsApi.md#postConfigScripts) | **POST** /api/v1/config/scripts | Adds a new custom script
*JansConfigApi.CustomScriptsApi* | [**putConfigScripts**](docs/CustomScriptsApi.md#putConfigScripts) | **PUT** /api/v1/config/scripts | Updates a custom script
*JansConfigApi.DatabaseApi* | [**getSchema**](docs/DatabaseApi.md#getSchema) | **GET** /api/v1/config/database | Gets schema objects
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**deleteConfigDatabaseLdapByName**](docs/DatabaseLDAPConfigurationApi.md#deleteConfigDatabaseLdapByName) | **DELETE** /api/v1/config/database/ldap/{name} | Deletes an LDAP configuration
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**getConfigDatabaseLdap**](docs/DatabaseLDAPConfigurationApi.md#getConfigDatabaseLdap) | **GET** /api/v1/config/database/ldap | Gets list of existing LDAP configurations.
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**getConfigDatabaseLdapByName**](docs/DatabaseLDAPConfigurationApi.md#getConfigDatabaseLdapByName) | **GET** /api/v1/config/database/ldap/{name} | Gets an LDAP configuration by name.
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**patchConfigDatabaseLdapByName**](docs/DatabaseLDAPConfigurationApi.md#patchConfigDatabaseLdapByName) | **PATCH** /api/v1/config/database/ldap/{name} | Patches a LDAP configuration by name
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**postConfigDatabaseLdap**](docs/DatabaseLDAPConfigurationApi.md#postConfigDatabaseLdap) | **POST** /api/v1/config/database/ldap | Adds a new LDAP configuration
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**postConfigDatabaseLdapTest**](docs/DatabaseLDAPConfigurationApi.md#postConfigDatabaseLdapTest) | **POST** /api/v1/config/database/ldap/test | Tests an LDAP configuration
*JansConfigApi.DatabaseLDAPConfigurationApi* | [**putConfigDatabaseLdap**](docs/DatabaseLDAPConfigurationApi.md#putConfigDatabaseLdap) | **PUT** /api/v1/config/database/ldap | Updates LDAP configuration
*JansConfigApi.DefaultAuthenticationMethodApi* | [**getAcrs**](docs/DefaultAuthenticationMethodApi.md#getAcrs) | **GET** /api/v1/acrs | Gets default authentication method.
*JansConfigApi.DefaultAuthenticationMethodApi* | [**putAcrs**](docs/DefaultAuthenticationMethodApi.md#putAcrs) | **PUT** /api/v1/acrs | Updates default authentication method.
*JansConfigApi.Fido2ConfigurationApi* | [**getPropertiesFido2**](docs/Fido2ConfigurationApi.md#getPropertiesFido2) | **GET** /fido2/fido2-config | Gets Jans Authorization Server Fido2 configuration properties
*JansConfigApi.Fido2ConfigurationApi* | [**putPropertiesFido2**](docs/Fido2ConfigurationApi.md#putPropertiesFido2) | **PUT** /fido2/fido2-config | Updates Fido2 configuration properties
*JansConfigApi.Fido2RegistrationApi* | [**deleteFido2Data**](docs/Fido2RegistrationApi.md#deleteFido2Data) | **DELETE** /fido2/registration/id/{jansId} | Delete Fido2 Device Data based on device UID
*JansConfigApi.Fido2RegistrationApi* | [**getFido2ById**](docs/Fido2RegistrationApi.md#getFido2ById) | **GET** /fido2/registration/id/{jansId} | Fetch Fido2RegistrationEntry by Id.
*JansConfigApi.Fido2RegistrationApi* | [**getRegistrationEntriesFido2**](docs/Fido2RegistrationApi.md#getRegistrationEntriesFido2) | **GET** /fido2/registration/entries/{username} | Get details of connected FIDO2 devices registered to user
*JansConfigApi.Fido2RegistrationApi* | [**searchFido2RegistrationData**](docs/Fido2RegistrationApi.md#searchFido2RegistrationData) | **GET** /fido2/registration | Get a list of Fido2RegistrationEntry.
*JansConfigApi.HealthCheckApi* | [**getAppVersion**](docs/HealthCheckApi.md#getAppVersion) | **GET** /api/v1/health/app-version | Returns application version
*JansConfigApi.HealthCheckApi* | [**getConfigHealth**](docs/HealthCheckApi.md#getConfigHealth) | **GET** /api/v1/health | Returns application health status
*JansConfigApi.HealthCheckApi* | [**getConfigHealthLive**](docs/HealthCheckApi.md#getConfigHealthLive) | **GET** /api/v1/health/live | Returns application liveness status
*JansConfigApi.HealthCheckApi* | [**getConfigHealthReady**](docs/HealthCheckApi.md#getConfigHealthReady) | **GET** /api/v1/health/ready | Returns application readiness status
*JansConfigApi.HealthCheckApi* | [**getServerStat**](docs/HealthCheckApi.md#getServerStat) | **GET** /api/v1/health/server-stat | Returns application server status
*JansConfigApi.HealthCheckApi* | [**getServiceStatus**](docs/HealthCheckApi.md#getServiceStatus) | **GET** /api/v1/health/service-status | Fetch service status
*JansConfigApi.JansAssetsApi* | [**deleteAsset**](docs/JansAssetsApi.md#deleteAsset) | **DELETE** /api/v1/jans-assets/{inum} | Delete an asset
*JansConfigApi.JansAssetsApi* | [**getAllAssets**](docs/JansAssetsApi.md#getAllAssets) | **GET** /api/v1/jans-assets | Gets all Jans assets.
*JansConfigApi.JansAssetsApi* | [**getAssetByInum**](docs/JansAssetsApi.md#getAssetByInum) | **GET** /api/v1/jans-assets/{inum} | Gets an asset by inum - unique identifier
*JansConfigApi.JansAssetsApi* | [**getAssetByName**](docs/JansAssetsApi.md#getAssetByName) | **GET** /api/v1/jans-assets/name/{name} | Fetch asset by name
*JansConfigApi.JansAssetsApi* | [**getAssetDirMapping**](docs/JansAssetsApi.md#getAssetDirMapping) | **GET** /api/v1/jans-assets/asset-dir-mapping | Get valid asset types
*JansConfigApi.JansAssetsApi* | [**getAssetServices**](docs/JansAssetsApi.md#getAssetServices) | **GET** /api/v1/jans-assets/services | Gets asset services
*JansConfigApi.JansAssetsApi* | [**getAssetTypes**](docs/JansAssetsApi.md#getAssetTypes) | **GET** /api/v1/jans-assets/asset-type | Get valid asset types
*JansConfigApi.JansAssetsApi* | [**loadServiceAsset**](docs/JansAssetsApi.md#loadServiceAsset) | **POST** /api/v1/jans-assets/service/{service-name} | Load assets on server for a service
*JansConfigApi.JansAssetsApi* | [**postNewAsset**](docs/JansAssetsApi.md#postNewAsset) | **POST** /api/v1/jans-assets/upload | Upload new asset
*JansConfigApi.JansAssetsApi* | [**putAsset**](docs/JansAssetsApi.md#putAsset) | **PUT** /api/v1/jans-assets/upload | Update existing asset
*JansConfigApi.JansLinkConfigurationApi* | [**getJansLinkProperties**](docs/JansLinkConfigurationApi.md#getJansLinkProperties) | **GET** /jans-link/link-config | Gets Jans Link App configuration.
*JansConfigApi.JansLinkConfigurationApi* | [**putJansLinkProperties**](docs/JansLinkConfigurationApi.md#putJansLinkProperties) | **PUT** /jans-link/link-config | Updates Jans Link configuration properties.
*JansConfigApi.KCLinkConfigurationApi* | [**getKcLinkProperties**](docs/KCLinkConfigurationApi.md#getKcLinkProperties) | **GET** /kc-link/kcLinkConfig | Gets KC Link configuration properties
*JansConfigApi.KCLinkConfigurationApi* | [**patchKcLinkProperties**](docs/KCLinkConfigurationApi.md#patchKcLinkProperties) | **PATCH** /kc-link/kcLinkConfig | Partially modifies KC Link configuration properties.
*JansConfigApi.KCLinkConfigurationApi* | [**putKcLinkProperties**](docs/KCLinkConfigurationApi.md#putKcLinkProperties) | **PUT** /kc-link/kcLinkConfig | Update KC Link configuration properties
*JansConfigApi.LockAuditApi* | [**bulkSaveHealthData**](docs/LockAuditApi.md#bulkSaveHealthData) | **POST** /lock/audit/health/bulk | Bulk save health data
*JansConfigApi.LockAuditApi* | [**bulkSaveLogData**](docs/LockAuditApi.md#bulkSaveLogData) | **POST** /lock/audit/log/bulk | Bulk save log data
*JansConfigApi.LockAuditApi* | [**bulkSaveTelemetryData**](docs/LockAuditApi.md#bulkSaveTelemetryData) | **POST** /lock/audit/telemetry/bulk | Bulk save telemetry data
*JansConfigApi.LockAuditApi* | [**requestLockHealthRecordsEventRange**](docs/LockAuditApi.md#requestLockHealthRecordsEventRange) | **GET** /lock/audit/health/search | Rerquest health records for specific event range
*JansConfigApi.LockAuditApi* | [**requestLockTelemetryRecordsEventRange**](docs/LockAuditApi.md#requestLockTelemetryRecordsEventRange) | **GET** /lock/audit/telemetry/search | Request telemetry records for specific event range
*JansConfigApi.LockAuditApi* | [**saveHealthData**](docs/LockAuditApi.md#saveHealthData) | **POST** /lock/audit/health | Save health data
*JansConfigApi.LockAuditApi* | [**saveLogData**](docs/LockAuditApi.md#saveLogData) | **POST** /lock/audit/log | Save log data
*JansConfigApi.LockAuditApi* | [**saveTelemetryData**](docs/LockAuditApi.md#saveTelemetryData) | **POST** /lock/audit/telemetry | Save telemetry data
*JansConfigApi.LockConfigurationApi* | [**getLockProperties**](docs/LockConfigurationApi.md#getLockProperties) | **GET** /lock/lockConfig | Gets Lock configuration properties
*JansConfigApi.LockConfigurationApi* | [**patchLockProperties**](docs/LockConfigurationApi.md#patchLockProperties) | **PATCH** /lock/lockConfig | Partially modifies Lock configuration properties.
*JansConfigApi.LockConfigurationApi* | [**putLockProperties**](docs/LockConfigurationApi.md#putLockProperties) | **PUT** /lock/lockConfig | Update Lock configuration properties
*JansConfigApi.LockLogApi* | [**requestLockLogRecordsEventRange**](docs/LockLogApi.md#requestLockLogRecordsEventRange) | **GET** /lock/audit/log/search | Rerquest log records for specific event range
*JansConfigApi.LogsApi* | [**getAuditData**](docs/LogsApi.md#getAuditData) | **GET** /api/v1/audit | Get audit details.
*JansConfigApi.MessageConfigurationApi* | [**getConfigMessage**](docs/MessageConfigurationApi.md#getConfigMessage) | **GET** /api/v1/config/message | Returns message configuration.
*JansConfigApi.MessageConfigurationApi* | [**patchConfigMessage**](docs/MessageConfigurationApi.md#patchConfigMessage) | **PATCH** /api/v1/config/message | Patch message configuration.
*JansConfigApi.MessageConfigurationPostgresApi* | [**getConfigMessagePostgres**](docs/MessageConfigurationPostgresApi.md#getConfigMessagePostgres) | **GET** /api/v1/config/message/postgres | Returns Postgres message configuration.
*JansConfigApi.MessageConfigurationPostgresApi* | [**patchConfigMessagePostgres**](docs/MessageConfigurationPostgresApi.md#patchConfigMessagePostgres) | **PATCH** /api/v1/config/message/postgres | Patch Postgres message configuration.
*JansConfigApi.MessageConfigurationPostgresApi* | [**putConfigMessagePostgres**](docs/MessageConfigurationPostgresApi.md#putConfigMessagePostgres) | **PUT** /api/v1/config/message/postgres | Updates Postgres message configuration.
*JansConfigApi.MessageConfigurationRedisApi* | [**getConfigMessageRedis**](docs/MessageConfigurationRedisApi.md#getConfigMessageRedis) | **GET** /api/v1/config/message/redis | Returns Redis message configuration.
*JansConfigApi.MessageConfigurationRedisApi* | [**patchConfigMessageRedis**](docs/MessageConfigurationRedisApi.md#patchConfigMessageRedis) | **PATCH** /api/v1/config/message/redis | Patch Redis message configuration.
*JansConfigApi.MessageConfigurationRedisApi* | [**putConfigMessageRedis**](docs/MessageConfigurationRedisApi.md#putConfigMessageRedis) | **PUT** /api/v1/config/message/redis | Updates Redis message configuration.
*JansConfigApi.OAuthOpenIDConnectClientsApi* | [**deleteOauthOpenidClientByInum**](docs/OAuthOpenIDConnectClientsApi.md#deleteOauthOpenidClientByInum) | **DELETE** /api/v1/openid/clients/{inum} | Delete OpenId Connect client
*JansConfigApi.OAuthOpenIDConnectClientsApi* | [**getOauthOpenidClients**](docs/OAuthOpenIDConnectClientsApi.md#getOauthOpenidClients) | **GET** /api/v1/openid/clients | Gets list of OpenID Connect clients
*JansConfigApi.OAuthOpenIDConnectClientsApi* | [**getOauthOpenidClientsByInum**](docs/OAuthOpenIDConnectClientsApi.md#getOauthOpenidClientsByInum) | **GET** /api/v1/openid/clients/{inum} | Get OpenId Connect Client by Inum
*JansConfigApi.OAuthOpenIDConnectClientsApi* | [**patchOauthOpenidClientByInum**](docs/OAuthOpenIDConnectClientsApi.md#patchOauthOpenidClientByInum) | **PATCH** /api/v1/openid/clients/{inum} | Patch OpenId Connect client
*JansConfigApi.OAuthOpenIDConnectClientsApi* | [**postOauthOpenidClient**](docs/OAuthOpenIDConnectClientsApi.md#postOauthOpenidClient) | **POST** /api/v1/openid/clients | Create new OpenId Connect client
*JansConfigApi.OAuthOpenIDConnectClientsApi* | [**putOauthOpenidClient**](docs/OAuthOpenIDConnectClientsApi.md#putOauthOpenidClient) | **PUT** /api/v1/openid/clients | Update OpenId Connect client
*JansConfigApi.OAuthScopesApi* | [**deleteOauthScopesByInum**](docs/OAuthScopesApi.md#deleteOauthScopesByInum) | **DELETE** /api/v1/scopes/{inum} | Delete Scope
*JansConfigApi.OAuthScopesApi* | [**getOauthScopes**](docs/OAuthScopesApi.md#getOauthScopes) | **GET** /api/v1/scopes | Gets list of Scopes
*JansConfigApi.OAuthScopesApi* | [**getOauthScopesByInum**](docs/OAuthScopesApi.md#getOauthScopesByInum) | **GET** /api/v1/scopes/{inum} | Get Scope by Inum
*JansConfigApi.OAuthScopesApi* | [**getScopeByCreator**](docs/OAuthScopesApi.md#getScopeByCreator) | **GET** /api/v1/scopes/creator/{creatorId} | Get Scope by creatorId
*JansConfigApi.OAuthScopesApi* | [**getScopeByType**](docs/OAuthScopesApi.md#getScopeByType) | **GET** /api/v1/scopes/type/{type} | Get Scope by type
*JansConfigApi.OAuthScopesApi* | [**patchOauthScopesById**](docs/OAuthScopesApi.md#patchOauthScopesById) | **PATCH** /api/v1/scopes/{inum} | Patch Scope
*JansConfigApi.OAuthScopesApi* | [**postOauthScopes**](docs/OAuthScopesApi.md#postOauthScopes) | **POST** /api/v1/scopes | Create Scope
*JansConfigApi.OAuthScopesApi* | [**putOauthScopes**](docs/OAuthScopesApi.md#putOauthScopes) | **PUT** /api/v1/scopes | Update Scope
*JansConfigApi.OAuthUMAResourcesApi* | [**deleteOauthUmaResourcesById**](docs/OAuthUMAResourcesApi.md#deleteOauthUmaResourcesById) | **DELETE** /api/v1/uma/resources/{id} | Deletes an UMA resource
*JansConfigApi.OAuthUMAResourcesApi* | [**getOauthUmaResources**](docs/OAuthUMAResourcesApi.md#getOauthUmaResources) | **GET** /api/v1/uma/resources | Gets list of UMA resources
*JansConfigApi.OAuthUMAResourcesApi* | [**getOauthUmaResourcesByClientid**](docs/OAuthUMAResourcesApi.md#getOauthUmaResourcesByClientid) | **GET** /api/v1/uma/resources/clientId/{clientId} | Fetch uma resources by client id
*JansConfigApi.OAuthUMAResourcesApi* | [**getOauthUmaResourcesById**](docs/OAuthUMAResourcesApi.md#getOauthUmaResourcesById) | **GET** /api/v1/uma/resources/{id} | Gets an UMA resource by ID
*JansConfigApi.OAuthUMAResourcesApi* | [**patchOauthUmaResourcesById**](docs/OAuthUMAResourcesApi.md#patchOauthUmaResourcesById) | **PATCH** /api/v1/uma/resources/{id} | Patch UMA resource
*JansConfigApi.OAuthUMAResourcesApi* | [**postOauthUmaResources**](docs/OAuthUMAResourcesApi.md#postOauthUmaResources) | **POST** /api/v1/uma/resources | Creates an UMA resource
*JansConfigApi.OAuthUMAResourcesApi* | [**putOauthUmaResources**](docs/OAuthUMAResourcesApi.md#putOauthUmaResources) | **PUT** /api/v1/uma/resources | Updates an UMA resource
*JansConfigApi.OrganizationConfigurationApi* | [**getOrganizationConfig**](docs/OrganizationConfigurationApi.md#getOrganizationConfig) | **GET** /api/v1/org | Retrieves organization configuration
*JansConfigApi.OrganizationConfigurationApi* | [**patchOrganizationConfig**](docs/OrganizationConfigurationApi.md#patchOrganizationConfig) | **PATCH** /api/v1/org | Patch organization configuration
*JansConfigApi.PluginsApi* | [**getPluginByName**](docs/PluginsApi.md#getPluginByName) | **GET** /api/v1/plugin/{pluginName} | Get plugin by name
*JansConfigApi.PluginsApi* | [**getPlugins**](docs/PluginsApi.md#getPlugins) | **GET** /api/v1/plugin | Gets list of Plugins
*JansConfigApi.SAMLConfigurationApi* | [**getSamlProperties**](docs/SAMLConfigurationApi.md#getSamlProperties) | **GET** /kc/samlConfig | Gets SAML configuration properties
*JansConfigApi.SAMLConfigurationApi* | [**patchSamlProperties**](docs/SAMLConfigurationApi.md#patchSamlProperties) | **PATCH** /kc/samlConfig | Partially modifies SAML configuration properties.
*JansConfigApi.SAMLConfigurationApi* | [**putSamlProperties**](docs/SAMLConfigurationApi.md#putSamlProperties) | **PUT** /kc/samlConfig | Update SAML configuration properties
*JansConfigApi.SAMLIdentityBrokerApi* | [**deleteSamlIdentityProvider**](docs/SAMLIdentityBrokerApi.md#deleteSamlIdentityProvider) | **DELETE** /kc/saml/idp/{inum} | Delete SAML Identity Provider
*JansConfigApi.SAMLIdentityBrokerApi* | [**getSamlIdentityProvider**](docs/SAMLIdentityBrokerApi.md#getSamlIdentityProvider) | **GET** /kc/saml/idp | Retrieves SAML Identity Provider
*JansConfigApi.SAMLIdentityBrokerApi* | [**getSamlIdentityProviderByInum**](docs/SAMLIdentityBrokerApi.md#getSamlIdentityProviderByInum) | **GET** /kc/saml/idp/{inum} | Get SAML Identity Provider by Inum
*JansConfigApi.SAMLIdentityBrokerApi* | [**getSamlSpMetadataJson**](docs/SAMLIdentityBrokerApi.md#getSamlSpMetadataJson) | **GET** /kc/saml/idp/sp-metadata/{inum} | Get SAML SP Metadata as Json
*JansConfigApi.SAMLIdentityBrokerApi* | [**getSamlSpMetadataUrl**](docs/SAMLIdentityBrokerApi.md#getSamlSpMetadataUrl) | **GET** /kc/saml/idp/sp-metadata-file/{inum} | Get SAML SP Metadata Endpoint URL
*JansConfigApi.SAMLIdentityBrokerApi* | [**postSamlIdentityProvider**](docs/SAMLIdentityBrokerApi.md#postSamlIdentityProvider) | **POST** /kc/saml/idp/upload | Create SAML Identity Provider
*JansConfigApi.SAMLIdentityBrokerApi* | [**putSamlIdentityProvider**](docs/SAMLIdentityBrokerApi.md#putSamlIdentityProvider) | **PUT** /kc/saml/idp/upload | Update SAML Identity Provider
*JansConfigApi.SAMLTrustRelationshipApi* | [**deleteTrustRelationship**](docs/SAMLTrustRelationshipApi.md#deleteTrustRelationship) | **DELETE** /kc/saml/trust-relationship/{id} | Delete TrustRelationship
*JansConfigApi.SAMLTrustRelationshipApi* | [**getTrustRelationshipById**](docs/SAMLTrustRelationshipApi.md#getTrustRelationshipById) | **GET** /kc/saml/trust-relationship/id/{id} | Get TrustRelationship by Id
*JansConfigApi.SAMLTrustRelationshipApi* | [**getTrustRelationshipFileMetadata**](docs/SAMLTrustRelationshipApi.md#getTrustRelationshipFileMetadata) | **GET** /kc/saml/trust-relationship/sp-metadata-file/{id} | Get TrustRelationship file metadata
*JansConfigApi.SAMLTrustRelationshipApi* | [**getTrustRelationships**](docs/SAMLTrustRelationshipApi.md#getTrustRelationships) | **GET** /kc/saml/trust-relationship | Get all Trust Relationship
*JansConfigApi.SAMLTrustRelationshipApi* | [**postTrustRelationshipMetadataFile**](docs/SAMLTrustRelationshipApi.md#postTrustRelationshipMetadataFile) | **POST** /kc/saml/trust-relationship/upload | Create Trust Relationship with Metadata File
*JansConfigApi.SAMLTrustRelationshipApi* | [**putTrustRelationship**](docs/SAMLTrustRelationshipApi.md#putTrustRelationship) | **PUT** /kc/saml/trust-relationship/upload | Update TrustRelationship
*JansConfigApi.SCIMConfigManagementApi* | [**getScimConfig**](docs/SCIMConfigManagementApi.md#getScimConfig) | **GET** /scim/scim-config | Retrieves SCIM App configuration
*JansConfigApi.SCIMConfigManagementApi* | [**patchScimConfig**](docs/SCIMConfigManagementApi.md#patchScimConfig) | **PATCH** /scim/scim-config | Patch SCIM App configuration
*JansConfigApi.StatisticsApi* | [**getLockStat**](docs/StatisticsApi.md#getLockStat) | **GET** /lock/lockStat | Provides basic statistic
*JansConfigApi.StatisticsUserApi* | [**getStat**](docs/StatisticsUserApi.md#getStat) | **GET** /api/v1/stat | Provides server with basic statistic
*JansConfigApi.TokenApi* | [**getTokenByClient**](docs/TokenApi.md#getTokenByClient) | **GET** /api/v1/token/client/{clientId} | Get token details by client.
*JansConfigApi.TokenApi* | [**getTokenById**](docs/TokenApi.md#getTokenById) | **GET** /api/v1/token/tknCde/{tknCde} | Get token details by Id.
*JansConfigApi.TokenApi* | [**revokeToken**](docs/TokenApi.md#revokeToken) | **DELETE** /api/v1/token/revoke/{tknCde} | Revoke client token.
*JansConfigApi.TokenApi* | [**searchToken**](docs/TokenApi.md#searchToken) | **GET** /api/v1/token/search | Search tokens


## Documentation for Models

 - [JansConfigApi.AdminPermission](docs/AdminPermission.md)
 - [JansConfigApi.AdminRole](docs/AdminRole.md)
 - [JansConfigApi.AgamaConfiguration](docs/AgamaConfiguration.md)
 - [JansConfigApi.ApiAppConfiguration](docs/ApiAppConfiguration.md)
 - [JansConfigApi.ApiError](docs/ApiError.md)
 - [JansConfigApi.AppConfigResponse](docs/AppConfigResponse.md)
 - [JansConfigApi.AppConfiguration](docs/AppConfiguration.md)
 - [JansConfigApi.AppConfiguration1](docs/AppConfiguration1.md)
 - [JansConfigApi.AppConfiguration2](docs/AppConfiguration2.md)
 - [JansConfigApi.AppConfiguration3](docs/AppConfiguration3.md)
 - [JansConfigApi.AppConfiguration4](docs/AppConfiguration4.md)
 - [JansConfigApi.AppConfiguration5](docs/AppConfiguration5.md)
 - [JansConfigApi.AssetDirMapping](docs/AssetDirMapping.md)
 - [JansConfigApi.AssetForm](docs/AssetForm.md)
 - [JansConfigApi.AssetMgtConfiguration](docs/AssetMgtConfiguration.md)
 - [JansConfigApi.AttributeType](docs/AttributeType.md)
 - [JansConfigApi.AttributeValidation](docs/AttributeValidation.md)
 - [JansConfigApi.AuditLogConf](docs/AuditLogConf.md)
 - [JansConfigApi.AuiFeature](docs/AuiFeature.md)
 - [JansConfigApi.AuthenticationFilter](docs/AuthenticationFilter.md)
 - [JansConfigApi.AuthenticationMethod](docs/AuthenticationMethod.md)
 - [JansConfigApi.AuthenticationProtectionConfiguration](docs/AuthenticationProtectionConfiguration.md)
 - [JansConfigApi.AuthorizationRequestCustomParameter](docs/AuthorizationRequestCustomParameter.md)
 - [JansConfigApi.BrokerIdentityProviderForm](docs/BrokerIdentityProviderForm.md)
 - [JansConfigApi.CIBAEndUserNotificationConfig](docs/CIBAEndUserNotificationConfig.md)
 - [JansConfigApi.CacheConfiguration](docs/CacheConfiguration.md)
 - [JansConfigApi.Client](docs/Client.md)
 - [JansConfigApi.ClientAttributes](docs/ClientAttributes.md)
 - [JansConfigApi.ClientAuth](docs/ClientAuth.md)
 - [JansConfigApi.ClientAuthenticationFilter](docs/ClientAuthenticationFilter.md)
 - [JansConfigApi.ConnectionServiceConfiguration](docs/ConnectionServiceConfiguration.md)
 - [JansConfigApi.CorsConfigurationFilter](docs/CorsConfigurationFilter.md)
 - [JansConfigApi.CustomObjectAttribute](docs/CustomObjectAttribute.md)
 - [JansConfigApi.CustomScope](docs/CustomScope.md)
 - [JansConfigApi.CustomScript](docs/CustomScript.md)
 - [JansConfigApi.CustomUser](docs/CustomUser.md)
 - [JansConfigApi.DataFormatConversionConf](docs/DataFormatConversionConf.md)
 - [JansConfigApi.DatabaseSchemaMap](docs/DatabaseSchemaMap.md)
 - [JansConfigApi.Deployment](docs/Deployment.md)
 - [JansConfigApi.DeploymentDetails](docs/DeploymentDetails.md)
 - [JansConfigApi.Document](docs/Document.md)
 - [JansConfigApi.DocumentPagedResult](docs/DocumentPagedResult.md)
 - [JansConfigApi.EngineConfig](docs/EngineConfig.md)
 - [JansConfigApi.FacterData](docs/FacterData.md)
 - [JansConfigApi.Fido2Configuration](docs/Fido2Configuration.md)
 - [JansConfigApi.Fido2DeviceData](docs/Fido2DeviceData.md)
 - [JansConfigApi.Fido2DeviceNotificationConf](docs/Fido2DeviceNotificationConf.md)
 - [JansConfigApi.Fido2RegistrationData](docs/Fido2RegistrationData.md)
 - [JansConfigApi.Fido2RegistrationEntry](docs/Fido2RegistrationEntry.md)
 - [JansConfigApi.Fido2RegistrationEntryPagedResult](docs/Fido2RegistrationEntryPagedResult.md)
 - [JansConfigApi.GenericResponse](docs/GenericResponse.md)
 - [JansConfigApi.GluuLdapConfiguration](docs/GluuLdapConfiguration.md)
 - [JansConfigApi.GluuOrganization](docs/GluuOrganization.md)
 - [JansConfigApi.HealthEntry](docs/HealthEntry.md)
 - [JansConfigApi.HealthStatus](docs/HealthStatus.md)
 - [JansConfigApi.IdentityProvider](docs/IdentityProvider.md)
 - [JansConfigApi.IdentityProviderPagedResult](docs/IdentityProviderPagedResult.md)
 - [JansConfigApi.InMemoryConfiguration](docs/InMemoryConfiguration.md)
 - [JansConfigApi.JSONWebKey](docs/JSONWebKey.md)
 - [JansConfigApi.JansAttribute](docs/JansAttribute.md)
 - [JansConfigApi.KeyValuePair](docs/KeyValuePair.md)
 - [JansConfigApi.KeycloakConfiguration](docs/KeycloakConfiguration.md)
 - [JansConfigApi.LicenseRequest](docs/LicenseRequest.md)
 - [JansConfigApi.LicenseResponse](docs/LicenseResponse.md)
 - [JansConfigApi.LinkAttributeMapping](docs/LinkAttributeMapping.md)
 - [JansConfigApi.LocalizedString](docs/LocalizedString.md)
 - [JansConfigApi.LockMessageConfig](docs/LockMessageConfig.md)
 - [JansConfigApi.LogEntry](docs/LogEntry.md)
 - [JansConfigApi.LogPagedResult](docs/LogPagedResult.md)
 - [JansConfigApi.Logging](docs/Logging.md)
 - [JansConfigApi.MemcachedConfiguration](docs/MemcachedConfiguration.md)
 - [JansConfigApi.MessageConfiguration](docs/MessageConfiguration.md)
 - [JansConfigApi.MetadataServer](docs/MetadataServer.md)
 - [JansConfigApi.NativePersistenceConfiguration](docs/NativePersistenceConfiguration.md)
 - [JansConfigApi.PagedResult](docs/PagedResult.md)
 - [JansConfigApi.PatchRequest](docs/PatchRequest.md)
 - [JansConfigApi.PersistenceConfiguration](docs/PersistenceConfiguration.md)
 - [JansConfigApi.PluginConf](docs/PluginConf.md)
 - [JansConfigApi.PostgresMessageConfiguration](docs/PostgresMessageConfiguration.md)
 - [JansConfigApi.ProfileConfiguration](docs/ProfileConfiguration.md)
 - [JansConfigApi.ProjectMetadata](docs/ProjectMetadata.md)
 - [JansConfigApi.RedisConfiguration](docs/RedisConfiguration.md)
 - [JansConfigApi.RedisMessageConfiguration](docs/RedisMessageConfiguration.md)
 - [JansConfigApi.RequestedParty](docs/RequestedParty.md)
 - [JansConfigApi.RolePermissionMapping](docs/RolePermissionMapping.md)
 - [JansConfigApi.SAMLMetadata](docs/SAMLMetadata.md)
 - [JansConfigApi.SSARequest](docs/SSARequest.md)
 - [JansConfigApi.SamlAppConfiguration](docs/SamlAppConfiguration.md)
 - [JansConfigApi.Scope](docs/Scope.md)
 - [JansConfigApi.ScopeAttributes](docs/ScopeAttributes.md)
 - [JansConfigApi.ScriptError](docs/ScriptError.md)
 - [JansConfigApi.SessionId](docs/SessionId.md)
 - [JansConfigApi.SessionIdAccessMap](docs/SessionIdAccessMap.md)
 - [JansConfigApi.SessionIdPredefinedAttributes](docs/SessionIdPredefinedAttributes.md)
 - [JansConfigApi.SessionPagedResult](docs/SessionPagedResult.md)
 - [JansConfigApi.ShortCodeRequest](docs/ShortCodeRequest.md)
 - [JansConfigApi.SimpleCustomProperty](docs/SimpleCustomProperty.md)
 - [JansConfigApi.SimpleExtendedCustomProperty](docs/SimpleExtendedCustomProperty.md)
 - [JansConfigApi.SmtpConfiguration](docs/SmtpConfiguration.md)
 - [JansConfigApi.SmtpTest](docs/SmtpTest.md)
 - [JansConfigApi.SsaConfiguration](docs/SsaConfiguration.md)
 - [JansConfigApi.SsaValidationConfig](docs/SsaValidationConfig.md)
 - [JansConfigApi.StatsData](docs/StatsData.md)
 - [JansConfigApi.Status](docs/Status.md)
 - [JansConfigApi.TelemetryEntry](docs/TelemetryEntry.md)
 - [JansConfigApi.TokenAttributes](docs/TokenAttributes.md)
 - [JansConfigApi.TokenEntity](docs/TokenEntity.md)
 - [JansConfigApi.TokenEntityPagedResult](docs/TokenEntityPagedResult.md)
 - [JansConfigApi.TrustRelationship](docs/TrustRelationship.md)
 - [JansConfigApi.TrustRelationshipForm](docs/TrustRelationshipForm.md)
 - [JansConfigApi.TrustedIssuerConfig](docs/TrustedIssuerConfig.md)
 - [JansConfigApi.UmaResource](docs/UmaResource.md)
 - [JansConfigApi.User](docs/User.md)
 - [JansConfigApi.UserAuthenticator](docs/UserAuthenticator.md)
 - [JansConfigApi.UserAuthenticatorList](docs/UserAuthenticatorList.md)
 - [JansConfigApi.UserPagedResult](docs/UserPagedResult.md)
 - [JansConfigApi.UserPatchRequest](docs/UserPatchRequest.md)
 - [JansConfigApi.WebKeysConfiguration](docs/WebKeysConfiguration.md)
 - [JansConfigApi.WebhookEntry](docs/WebhookEntry.md)


## Documentation for Authorization



### oauth2


- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
  - https://jans.io/oauth/jans-auth-server/config/properties.readonly: View Auth Server properties related information
  - https://jans.io/oauth/jans-auth-server/config/properties.write: Manage Auth Server properties related information
  - https://jans.io/oauth/config/attributes.readonly: View attribute related information
  - https://jans.io/oauth/config/attributes.write: Manage attribute related information
  - https://jans.io/oauth/config/attributes.delete: Delete attribute related information
  - https://jans.io/oauth/config/acrs.readonly: View ACRS related information
  - https://jans.io/oauth/config/acrs.write: Manage ACRS related information
  - https://jans.io/oauth/config/database/ldap.readonly: View LDAP database related information
  - https://jans.io/oauth/config/database/ldap.write: Manage LDAP database related information
  - https://jans.io/oauth/config/database/ldap.delete: Delete LDAP database related information
  - https://jans.io/oauth/config/scripts.readonly: View cache scripts information
  - https://jans.io/oauth/config/scripts.write: Manage scripts related information
  - https://jans.io/oauth/config/scripts.delete: Delete scripts related information
  - https://jans.io/oauth/config/cache.readonly: View cache related information
  - https://jans.io/oauth/config/cache.write: Manage cache related information
  - https://jans.io/oauth/config/smtp.readonly: View SMTP related information
  - https://jans.io/oauth/config/smtp.write: Manage SMTP related information
  - https://jans.io/oauth/config/smtp.delete: Delete SMTP related information
  - https://jans.io/oauth/config/logging.readonly: View logging related information
  - https://jans.io/oauth/config/logging.write: Manage logging related information
  - https://jans.io/oauth/config/jwks.readonly: View JWKS related information
  - https://jans.io/oauth/config/jwks.write: Manage JWKS related information
  - https://jans.io/oauth/config/jwks.delete: Delete JWKS related information
  - https://jans.io/oauth/config/openid/clients.readonly: View clients related information
  - https://jans.io/oauth/config/openid/clients.write: Manage clients related information
  - https://jans.io/oauth/config/openid/clients.delete: Delete clients related information
  - https://jans.io/oauth/config/scopes.readonly: View scope related information
  - https://jans.io/oauth/config/scopes.write: Manage scope related information
  - https://jans.io/oauth/config/scopes.delete: Delete scope related information
  - https://jans.io/oauth/config/uma/resources.readonly: View UMA Resource related information
  - https://jans.io/oauth/config/uma/resources.write: Manage UMA Resource related information
  - https://jans.io/oauth/config/uma/resources.delete: Delete UMA Resource related information
  - https://jans.io/oauth/config/stats.readonly: View server with basic statistic
  - https://jans.io/oauth/config/organization.readonly: View organization configuration information
  - https://jans.io/oauth/config/organization.write: Manage organization configuration information
  - https://jans.io/oauth/config/agama.readonly: View Agama Flow related information
  - https://jans.io/oauth/config/agama.write: Manage Agama Flow related information
  - https://jans.io/oauth/config/agama.delete: Delete Agama Flow related information
  - https://jans.io/oauth/jans-auth-server/session.readonly: View Session related information
  - https://jans.io/oauth/jans-auth-server/session.delete: Delete Session information
  - https://jans.io/oauth/config/read-all: Admin read scope
  - https://jans.io/oauth/config/write-all: Admin write scope
  - https://jans.io/oauth/config/delete-all: Admin delete scope
  - https://jans.io/oauth/config/openid-read: View OpenID functionality
  - https://jans.io/oauth/config/openid/openid-write: Manage OpenID functionality
  - https://jans.io/oauth/config/openid/openid-delete: Delete OpenID functionality
  - https://jans.io/oauth/config/uma-read: View UMA functionality
  - https://jans.io/oauth/config/uma-write: Manage UMA functionality
  - https://jans.io/oauth/config/uma-delete: Delete UMA functionality
  - https://jans.io/oauth/config/plugin.readonly: View Plugin information
  - https://jans.io/oauth/config/properties.readonly: View Config-API related configuration properties
  - https://jans.io/oauth/config/properties.write: Manage Config-API related configuration properties
  - https://jans.io/oauth/client/authorizations.readonly: View ClientAuthorizations
  - https://jans.io/oauth/client/authorizations.delete: Revoke ClientAuthorizations
  - https://jans.io/oauth/config/jans_asset-read: View Jans Assets
  - https://jans.io/oauth/config/jans_asset-write: Manage Jans Assets
  - https://jans.io/oauth/config/jans_asset-delete: Delete Jans Assets
  - https://jans.io/oauth/config/token.readonly: View Token details
  - https://jans.io/oauth/config/token.write: Manage Token details
  - https://jans.io/oauth/config/token.delete: Delete Token details
  - https://jans.io/oauth/config/data.readonly: View Config-API related data
  - https://jans.io/oauth/config/audit-read: View Audit Log related data

