"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectControlFlowStatements = collectControlFlowStatements;
exports.wrapDoExpressionInIIFE = wrapDoExpressionInIIFE;
var _core = require("@babel/core");
const mergeVisitors = _core.traverse.visitors.merge;
function throwError(path) {
  throw path.buildCodeFrameError("This control flow escape from do expression is not supported.");
}
const controlFlowVisitor = {
  FunctionParent(path) {
    path.skip();
  },
  "SwitchStatement|Loop"(_, state) {
    state.break.add(null);
    state.continue.add(null);
  },
  LabeledStatement(path, state) {
    const name = path.node.label.name;
    state.break.add(name);
  },
  BreakStatement(path, state) {
    var _path$node$label$name, _path$node$label;
    if (!state.break.has((_path$node$label$name = (_path$node$label = path.node.label) == null ? void 0 : _path$node$label.name) != null ? _path$node$label$name : null)) {
      throwError(path);
    }
  },
  ContinueStatement(path, state) {
    var _path$node$label$name2, _path$node$label2;
    if (!state.continue.has((_path$node$label$name2 = (_path$node$label2 = path.node.label) == null ? void 0 : _path$node$label2.name) != null ? _path$node$label$name2 : null)) {
      throwError(path);
    }
  },
  ReturnStatement(path, state) {
    state.returnPath = path;
  }
};
function collectControlFlowStatements(path) {
  const state = {
    break: new Set(),
    continue: new Set(),
    returnPath: null
  };
  path.traverse(controlFlowVisitor, state);
  return state;
}
function wrapDoExpressionInIIFE(path) {
  const state = {
    break: new Set(),
    continue: new Set(),
    returnPath: null
  };
  path.traverse(mergeVisitors([{
    DoExpression(path) {
      const body = path.node.body.body;
      if (body.length) {
        path.replaceExpressionWithStatements(body);
      } else {
        path.replaceWith(path.scope.buildUndefinedNode());
      }
    }
  }, controlFlowVisitor]), state);
  if (state.returnPath) {
    throwError(state.returnPath);
  }
}

//# sourceMappingURL=utils.js.map
