import PropTypes from 'prop-types';
import React, { ChangeEvent, FocusEvent, KeyboardEvent, MouseEvent, SyntheticEvent } from 'react';
import { noop } from '../utils';
import type { Option, SelectEvent, TypeaheadProps, TypeaheadState } from '../types';
type Props = TypeaheadProps;
declare class Typeahead extends React.Component<Props, TypeaheadState> {
    static propTypes: {
        allowNew: PropTypes.Requireable<NonNullable<boolean | ((...args: any[]) => any) | null | undefined>>;
        autoFocus: PropTypes.Requireable<boolean>;
        caseSensitive: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        defaultInputValue: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        defaultOpen: PropTypes.Requireable<boolean>;
        defaultSelected: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        filterBy: PropTypes.Requireable<NonNullable<string[] | ((...args: any[]) => any) | null | undefined>>;
        highlightOnlyResult: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        id: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        ignoreDiacritics: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        labelKey: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
        maxResults: PropTypes.Requireable<number>;
        minLength: PropTypes.Requireable<number>;
        multiple: PropTypes.Requireable<boolean>;
        onBlur: PropTypes.Requireable<(...args: any[]) => any>;
        onChange: PropTypes.Requireable<(...args: any[]) => any>;
        onFocus: PropTypes.Requireable<(...args: any[]) => any>;
        onInputChange: PropTypes.Requireable<(...args: any[]) => any>;
        onKeyDown: PropTypes.Requireable<(...args: any[]) => any>;
        onMenuToggle: PropTypes.Requireable<(...args: any[]) => any>;
        onPaginate: PropTypes.Requireable<(...args: any[]) => any>;
        open: PropTypes.Requireable<boolean>;
        options: PropTypes.Validator<(NonNullable<string | object | null | undefined> | null | undefined)[]>;
        paginate: PropTypes.Requireable<boolean>;
        selected: (props: TypeaheadProps, propName: keyof TypeaheadProps, componentName: string) => void;
    };
    static defaultProps: {
        allowNew: boolean;
        autoFocus: boolean;
        caseSensitive: boolean;
        defaultInputValue: string;
        defaultOpen: boolean;
        defaultSelected: never[];
        filterBy: never[];
        highlightOnlyResult: boolean;
        ignoreDiacritics: boolean;
        labelKey: string;
        maxResults: number;
        minLength: number;
        multiple: boolean;
        onBlur: typeof noop;
        onFocus: typeof noop;
        onInputChange: typeof noop;
        onKeyDown: typeof noop;
        onMenuToggle: typeof noop;
        onPaginate: typeof noop;
        paginate: boolean;
    };
    state: TypeaheadState;
    inputNode: HTMLInputElement | null;
    isMenuShown: boolean;
    items: Option[];
    componentDidMount(): void;
    componentDidUpdate(prevProps: Props, prevState: TypeaheadState): void;
    render(): React.JSX.Element;
    blur: () => void;
    clear: () => void;
    focus: () => void;
    getInput: () => HTMLInputElement | null;
    inputRef: (inputNode: HTMLInputElement | null) => void;
    setItem: (item: Option, position: number) => void;
    hideMenu: () => void;
    toggleMenu: () => void;
    _handleActiveIndexChange: (activeIndex: number) => void;
    _handleActiveItemChange: (activeItem: Option) => void;
    _handleBlur: (e: FocusEvent<HTMLInputElement>) => void;
    _handleChange: (selected: Option[]) => void;
    _handleClear: () => void;
    _handleClick: (e: MouseEvent<HTMLInputElement>) => void;
    _handleFocus: (e: SyntheticEvent<HTMLInputElement>) => void;
    _handleInitialItemChange: (initialItem?: Option) => void;
    _handleInputChange: (e: ChangeEvent<HTMLInputElement>) => void;
    _handleKeyDown: (e: KeyboardEvent<HTMLInputElement>) => void;
    _handleMenuItemSelect: (option: Option, e: SelectEvent<HTMLElement>) => void;
    _handlePaginate: (e: SelectEvent<HTMLElement>) => void;
    _handleSelectionAdd: (option: Option) => void;
    _handleSelectionRemove: (selection: Option) => void;
}
export default Typeahead;
