import PropTypes from 'prop-types';
import React, { ComponentType, FocusEvent, FocusEventHandler, HTMLProps, KeyboardEvent, MouseEvent, MouseEventHandler } from 'react';
import { Option, OptionHandler } from '../types';
export interface UseTokenProps<T> extends Omit<HTMLProps<T>, 'onBlur'> {
    onBlur?: (event: Event) => void;
    onClick?: MouseEventHandler<T>;
    onFocus?: FocusEventHandler<T>;
    onRemove?: OptionHandler;
    option: Option;
}
export declare function useToken<T extends HTMLElement>({ onBlur, onClick, onFocus, onRemove, option, ...props }: UseTokenProps<T>): {
    active: boolean;
    onBlur: (e: Event) => void;
    onClick: (e: MouseEvent<T>) => void;
    onFocus: (e: FocusEvent<T>) => void;
    onKeyDown: (e: KeyboardEvent<T>) => void;
    onRemove: (() => void) | undefined;
    ref: React.RefObject<HTMLDivElement>;
};
export declare function withToken<T extends UseTokenProps<HTMLElement>>(Component: ComponentType<T>): {
    (props: T): React.JSX.Element;
    displayName: string;
    propTypes: {
        onBlur: PropTypes.Requireable<(...args: any[]) => any>;
        onClick: PropTypes.Requireable<(...args: any[]) => any>;
        onFocus: PropTypes.Requireable<(...args: any[]) => any>;
        onRemove: PropTypes.Requireable<(...args: any[]) => any>;
        option: PropTypes.Validator<NonNullable<NonNullable<string | object | null | undefined>>>;
    };
};
