# JansConfigApi.ConfigurationSMTPApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConfigSmtp**](ConfigurationSMTPApi.md#deleteConfigSmtp) | **DELETE** /api/v1/config/smtp | Deletes SMTP server configuration
[**getConfigSmtp**](ConfigurationSMTPApi.md#getConfigSmtp) | **GET** /api/v1/config/smtp | Returns SMTP server configuration
[**postConfigSmtp**](ConfigurationSMTPApi.md#postConfigSmtp) | **POST** /api/v1/config/smtp | Adds SMTP server configuration
[**putConfigSmtp**](ConfigurationSMTPApi.md#putConfigSmtp) | **PUT** /api/v1/config/smtp | Updates SMTP server configuration
[**testConfigSmtp**](ConfigurationSMTPApi.md#testConfigSmtp) | **POST** /api/v1/config/smtp/test | Signing Test SMTP server configuration



## deleteConfigSmtp

> deleteConfigSmtp()

Deletes SMTP server configuration

Deletes SMTP server configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationSMTPApi();
apiInstance.deleteConfigSmtp((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getConfigSmtp

> SmtpConfiguration getConfigSmtp()

Returns SMTP server configuration

Returns SMTP server configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationSMTPApi();
apiInstance.getConfigSmtp((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**SmtpConfiguration**](SmtpConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## postConfigSmtp

> SmtpConfiguration postConfigSmtp(opts)

Adds SMTP server configuration

Adds SMTP server configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationSMTPApi();
let opts = {
  'smtpConfiguration': {
    "valid": true,
    "host": "localhost",
    "port": 260,
    "requires_ssl": true,
    "trust_host": true,
    "from_name": "John",
    "from_email_address": "john@grow.org",
    "requires_authentication": true,
    "user_name": "smtp_user",
    "password": "password"
}
 // SmtpConfiguration | SmtpConfiguration object
};
apiInstance.postConfigSmtp(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **smtpConfiguration** | [**SmtpConfiguration**](SmtpConfiguration.md)| SmtpConfiguration object | [optional] 

### Return type

[**SmtpConfiguration**](SmtpConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putConfigSmtp

> SmtpConfiguration putConfigSmtp(opts)

Updates SMTP server configuration

Updates SMTP server configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationSMTPApi();
let opts = {
  'smtpConfiguration': {
    "valid": true,
    "host": "localhost",
    "port": 260,
    "requires_ssl": true,
    "trust_host": true,
    "from_name": "John",
    "from_email_address": "john@grow.org",
    "requires_authentication": true,
    "user_name": "smtp_user",
    "password": "password"
}
 // SmtpConfiguration | SmtpConfiguration object
};
apiInstance.putConfigSmtp(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **smtpConfiguration** | [**SmtpConfiguration**](SmtpConfiguration.md)| SmtpConfiguration object | [optional] 

### Return type

[**SmtpConfiguration**](SmtpConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## testConfigSmtp

> Boolean testConfigSmtp(opts)

Signing Test SMTP server configuration

Signing Test SMTP server configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationSMTPApi();
let opts = {
  'smtpTest':  // SmtpTest | SmtpTest object
};
apiInstance.testConfigSmtp(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **smtpTest** | [**SmtpTest**](SmtpTest.md)| SmtpTest object | [optional] 

### Return type

**Boolean**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

