# JansConfigApi.AdminUICedarlingApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAdminuiPolicyStore**](AdminUICedarlingApi.md#getAdminuiPolicyStore) | **GET** /admin-ui/security/policyStore | Get Admin UI policy store
[**setRemotePolicyStoreAsDefault**](AdminUICedarlingApi.md#setRemotePolicyStoreAsDefault) | **PUT** /admin-ui/security/setRemotePolicyStoreAsDefault | Set remote policy store as default policy store of Admin UI
[**syncRoleToScopesMappings**](AdminUICedarlingApi.md#syncRoleToScopesMappings) | **POST** /admin-ui/security/syncRoleScopesMapping | Sync role-to-scope mappings from the policy store



## getAdminuiPolicyStore

> [GenericResponse] getAdminuiPolicyStore()

Get Admin UI policy store

Get Admin UI policy store

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUICedarlingApi();
apiInstance.getAdminuiPolicyStore((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[GenericResponse]**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## setRemotePolicyStoreAsDefault

> [GenericResponse] setRemotePolicyStoreAsDefault()

Set remote policy store as default policy store of Admin UI

Set remote policy store as default policy store of Admin UI

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUICedarlingApi();
apiInstance.setRemotePolicyStoreAsDefault((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[GenericResponse]**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## syncRoleToScopesMappings

> [GenericResponse] syncRoleToScopesMappings()

Sync role-to-scope mappings from the policy store

Sync the role-to-scope mappings from the policy store. If a remote policy store URL is configured and enabled, the mappings will be generated from the remote policy store; otherwise, they will be generated from the default policy store.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUICedarlingApi();
apiInstance.syncRoleToScopesMappings((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[GenericResponse]**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

