import cx from 'classnames';
import React, { forwardRef } from 'react';
import { useItem } from '../../behaviors/item';
export const BaseMenuItem = forwardRef(({ active, children, className, disabled, onClick, ...props }, ref) => {
    return (React.createElement("a", { ...props, className: cx('dropdown-item', { active, disabled }, className), href: props.href || '#', onClick: (e) => {
            e.preventDefault();
            !disabled && onClick && onClick(e);
        }, ref: ref }, children));
});
export default function MenuItem(props) {
    return React.createElement(BaseMenuItem, { ...useItem(props) });
}
