import React from 'react';
import Menu from './Menu';
import MenuItem from '../MenuItem';
const options = [{ label: 'Item 1' }, { label: 'Item 2' }, { label: 'Item 3' }];
export default {
    title: 'Components/Menu',
    component: Menu,
};
const children = options.map((o, idx) => (React.createElement(MenuItem, { key: o.label, option: o, position: idx }, o.label)));
const Template = (args) => (React.createElement(Menu, { ...args, style: {
        ...args.style,
        position: 'relative',
    } }));
export const Default = Template.bind({});
Default.args = {
    children,
    id: 'default-menu',
};
export const Empty = Template.bind({});
Empty.args = {
    id: 'empty-menu',
};
export const HeaderAndDivider = Template.bind({});
HeaderAndDivider.args = {
    children: (React.createElement(React.Fragment, null,
        React.createElement(Menu.Header, null, "This is a menu header"),
        React.createElement(Menu.Divider, null),
        React.createElement(MenuItem, { option: options[0], position: 0 }, options[0].label))),
    id: 'header-and-divider',
};
