"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _Highlighter = _interopRequireDefault(require("../Highlighter"));
var _Menu = _interopRequireDefault(require("../Menu"));
var _MenuItem = _interopRequireDefault(require("../MenuItem"));
var _utils = require("../../utils");
var _excluded = ["labelKey", "newSelectionPrefix", "options", "paginationText", "renderMenuItemChildren", "text"];
var propTypes = {
  /**
   * Provides the ability to specify a prefix before the user-entered text to
   * indicate that the selection will be new. No-op unless `allowNew={true}`.
   */
  newSelectionPrefix: _propTypes["default"].node,
  /**
   * Prompt displayed when large data sets are paginated.
   */
  paginationText: _propTypes["default"].node,
  /**
   * Provides a hook for customized rendering of menu item contents.
   */
  renderMenuItemChildren: _propTypes["default"].func
};
function renderMenuItemChildrenFn(option, props) {
  return /*#__PURE__*/_react["default"].createElement(_Highlighter["default"], {
    search: props.text
  }, (0, _utils.getOptionLabel)(option, props.labelKey));
}
var TypeaheadMenu = function TypeaheadMenu(props) {
  var labelKey = props.labelKey,
    _props$newSelectionPr = props.newSelectionPrefix,
    newSelectionPrefix = _props$newSelectionPr === void 0 ? 'New selection: ' : _props$newSelectionPr,
    options = props.options,
    _props$paginationText = props.paginationText,
    paginationText = _props$paginationText === void 0 ? 'Display additional results...' : _props$paginationText,
    _props$renderMenuItem = props.renderMenuItemChildren,
    renderMenuItemChildren = _props$renderMenuItem === void 0 ? renderMenuItemChildrenFn : _props$renderMenuItem,
    text = props.text,
    menuProps = (0, _objectWithoutProperties2["default"])(props, _excluded);
  var renderMenuItem = function renderMenuItem(option, position) {
    var label = (0, _utils.getOptionLabel)(option, labelKey);
    var menuItemProps = {
      disabled: !!(0, _utils.getOptionProperty)(option, 'disabled'),
      label: label,
      option: option,
      position: position
    };
    if ((0, _utils.getOptionProperty)(option, 'customOption')) {
      return /*#__PURE__*/_react["default"].createElement(_MenuItem["default"], (0, _extends2["default"])({}, menuItemProps, {
        className: "rbt-menu-custom-option",
        key: position,
        label: label
      }), newSelectionPrefix, /*#__PURE__*/_react["default"].createElement(_Highlighter["default"], {
        search: text
      }, label));
    }
    if ((0, _utils.getOptionProperty)(option, 'paginationOption')) {
      return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, {
        key: "pagination-option-divider"
      }, /*#__PURE__*/_react["default"].createElement(_Menu["default"].Divider, null), /*#__PURE__*/_react["default"].createElement(_MenuItem["default"], (0, _extends2["default"])({}, menuItemProps, {
        className: "rbt-menu-pagination-option",
        label:
        // TODO: Fix how (aria-)labels are passed to `MenuItem`.
        // `paginationText` can be a ReactNode.
        (0, _utils.isString)(paginationText) ? paginationText : ''
      }), paginationText));
    }
    return /*#__PURE__*/_react["default"].createElement(_MenuItem["default"], (0, _extends2["default"])({}, menuItemProps, {
      key: position
    }), renderMenuItemChildren(option, props, position));
  };
  return /*#__PURE__*/_react["default"].createElement(_Menu["default"], (0, _extends2["default"])({}, menuProps, {
    key:
    // Force a re-render if the text changes to ensure that menu
    // positioning updates correctly.
    text
  }), options.map(renderMenuItem));
};
TypeaheadMenu.propTypes = propTypes;
var _default = exports["default"] = TypeaheadMenu;