"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useOverlay = _interopRequireDefault(require("./useOverlay"));
var _constants = require("../../constants");
var _utils = require("../../utils");
var _excluded = ["referenceElement", "isMenuShown"];
// `Element` is not defined during server-side rendering, so shim it here.
/* istanbul ignore next */
var SafeElement = typeof Element === 'undefined' ? _utils.noop : Element;
var propTypes = {
  /**
   * Specify menu alignment. The default value is `justify`, which makes the
   * menu as wide as the input and truncates long values. Specifying `left`
   * or `right` will align the menu to that side and the width will be
   * determined by the length of menu item values.
   */
  align: _propTypes["default"].oneOf(_constants.ALIGN_VALUES),
  children: _propTypes["default"].func.isRequired,
  /**
   * Specify whether the menu should appear above the input.
   */
  dropup: _propTypes["default"].bool,
  /**
   * Whether or not to automatically adjust the position of the menu when it
   * reaches the viewport boundaries.
   */
  flip: _propTypes["default"].bool,
  isMenuShown: _propTypes["default"].bool,
  positionFixed: _propTypes["default"].bool,
  // @ts-ignore
  referenceElement: _propTypes["default"].instanceOf(SafeElement)
};
var Overlay = function Overlay(_ref) {
  var referenceElement = _ref.referenceElement,
    isMenuShown = _ref.isMenuShown,
    props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var overlayProps = (0, _useOverlay["default"])(referenceElement, props);
  if (!isMenuShown) {
    return null;
  }
  return props.children(overlayProps);
};
Overlay.propTypes = propTypes;
var _default = exports["default"] = Overlay;