"use strict";
"use client";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ReactQueryDevtoolsPanel.tsx
var ReactQueryDevtoolsPanel_exports = {};
__export(ReactQueryDevtoolsPanel_exports, {
  ReactQueryDevtoolsPanel: () => ReactQueryDevtoolsPanel
});
module.exports = __toCommonJS(ReactQueryDevtoolsPanel_exports);
var React = __toESM(require("react"), 1);
var import_react_query = require("@tanstack/react-query");
var import_query_devtools = require("@tanstack/query-devtools");
var import_jsx_runtime = require("react/jsx-runtime");
function ReactQueryDevtoolsPanel(props) {
  const queryClient = (0, import_react_query.useQueryClient)(props.client);
  const ref = React.useRef(null);
  const {
    errorTypes,
    styleNonce,
    shadowDOMTarget,
    hideDisabledQueries,
    theme
  } = props;
  const [devtools] = React.useState(
    new import_query_devtools.TanstackQueryDevtoolsPanel({
      client: queryClient,
      queryFlavor: "React Query",
      version: "5",
      onlineManager: import_react_query.onlineManager,
      buttonPosition: "bottom-left",
      position: "bottom",
      initialIsOpen: true,
      errorTypes,
      styleNonce,
      shadowDOMTarget,
      onClose: props.onClose,
      hideDisabledQueries,
      theme
    })
  );
  React.useEffect(() => {
    devtools.setClient(queryClient);
  }, [queryClient, devtools]);
  React.useEffect(() => {
    devtools.setOnClose(props.onClose ?? (() => {
    }));
  }, [props.onClose, devtools]);
  React.useEffect(() => {
    devtools.setErrorTypes(errorTypes || []);
  }, [errorTypes, devtools]);
  React.useEffect(() => {
    devtools.setTheme(theme);
  }, [theme, devtools]);
  React.useEffect(() => {
    if (ref.current) {
      devtools.mount(ref.current);
    }
    return () => {
      devtools.unmount();
    };
  }, [devtools]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    "div",
    {
      style: { height: "500px", ...props.style },
      className: "tsqd-parent-container",
      ref
    }
  );
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ReactQueryDevtoolsPanel
});
//# sourceMappingURL=ReactQueryDevtoolsPanel.cjs.map