/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import CedarlingConfiguration from './CedarlingConfiguration';

/**
 * The AppConfiguration5 model module.
 * @module model/AppConfiguration5
 * @version OAS Version
 */
class AppConfiguration5 {
    /**
     * Constructs a new <code>AppConfiguration5</code>.
     * @alias module:model/AppConfiguration5
     */
    constructor() { 
        
        AppConfiguration5.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>AppConfiguration5</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AppConfiguration5} obj Optional instance to populate.
     * @return {module:model/AppConfiguration5} The populated <code>AppConfiguration5</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new AppConfiguration5();

            if (data.hasOwnProperty('baseDN')) {
                obj['baseDN'] = ApiClient.convertToType(data['baseDN'], 'String');
            }
            if (data.hasOwnProperty('baseEndpoint')) {
                obj['baseEndpoint'] = ApiClient.convertToType(data['baseEndpoint'], 'String');
            }
            if (data.hasOwnProperty('openIdIssuer')) {
                obj['openIdIssuer'] = ApiClient.convertToType(data['openIdIssuer'], 'String');
            }
            if (data.hasOwnProperty('protectionMode')) {
                obj['protectionMode'] = ApiClient.convertToType(data['protectionMode'], 'String');
            }
            if (data.hasOwnProperty('auditPersistenceMode')) {
                obj['auditPersistenceMode'] = ApiClient.convertToType(data['auditPersistenceMode'], 'String');
            }
            if (data.hasOwnProperty('cedarlingConfiguration')) {
                obj['cedarlingConfiguration'] = CedarlingConfiguration.constructFromObject(data['cedarlingConfiguration']);
            }
            if (data.hasOwnProperty('statEnabled')) {
                obj['statEnabled'] = ApiClient.convertToType(data['statEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('statTimerIntervalInSeconds')) {
                obj['statTimerIntervalInSeconds'] = ApiClient.convertToType(data['statTimerIntervalInSeconds'], 'Number');
            }
            if (data.hasOwnProperty('tokenChannels')) {
                obj['tokenChannels'] = ApiClient.convertToType(data['tokenChannels'], ['String']);
            }
            if (data.hasOwnProperty('clientId')) {
                obj['clientId'] = ApiClient.convertToType(data['clientId'], 'String');
            }
            if (data.hasOwnProperty('clientPassword')) {
                obj['clientPassword'] = ApiClient.convertToType(data['clientPassword'], 'String');
            }
            if (data.hasOwnProperty('disableJdkLogger')) {
                obj['disableJdkLogger'] = ApiClient.convertToType(data['disableJdkLogger'], 'Boolean');
            }
            if (data.hasOwnProperty('loggingLevel')) {
                obj['loggingLevel'] = ApiClient.convertToType(data['loggingLevel'], 'String');
            }
            if (data.hasOwnProperty('loggingLayout')) {
                obj['loggingLayout'] = ApiClient.convertToType(data['loggingLayout'], 'String');
            }
            if (data.hasOwnProperty('externalLoggerConfiguration')) {
                obj['externalLoggerConfiguration'] = ApiClient.convertToType(data['externalLoggerConfiguration'], 'String');
            }
            if (data.hasOwnProperty('metricReporterInterval')) {
                obj['metricReporterInterval'] = ApiClient.convertToType(data['metricReporterInterval'], 'Number');
            }
            if (data.hasOwnProperty('metricReporterKeepDataDays')) {
                obj['metricReporterKeepDataDays'] = ApiClient.convertToType(data['metricReporterKeepDataDays'], 'Number');
            }
            if (data.hasOwnProperty('metricReporterEnabled')) {
                obj['metricReporterEnabled'] = ApiClient.convertToType(data['metricReporterEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('cleanServiceInterval')) {
                obj['cleanServiceInterval'] = ApiClient.convertToType(data['cleanServiceInterval'], 'Number');
            }
            if (data.hasOwnProperty('messageConsumerType')) {
                obj['messageConsumerType'] = ApiClient.convertToType(data['messageConsumerType'], 'String');
            }
            if (data.hasOwnProperty('errorReasonEnabled')) {
                obj['errorReasonEnabled'] = ApiClient.convertToType(data['errorReasonEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('cleanServiceBatchChunkSize')) {
                obj['cleanServiceBatchChunkSize'] = ApiClient.convertToType(data['cleanServiceBatchChunkSize'], 'Number');
            }
        }
        return obj;
    }


}

/**
 * Entry Base distinguished name (DN) that identifies the starting point of a search
 * @member {String} baseDN
 */
AppConfiguration5.prototype['baseDN'] = undefined;

/**
 * Lock base endpoint URL
 * @member {String} baseEndpoint
 */
AppConfiguration5.prototype['baseEndpoint'] = undefined;

/**
 * OpenID issuer URL
 * @member {String} openIdIssuer
 */
AppConfiguration5.prototype['openIdIssuer'] = undefined;

/**
 * Protection mode for the Lock server (OAuth or Cedarling)
 * @member {module:model/AppConfiguration5.ProtectionModeEnum} protectionMode
 */
AppConfiguration5.prototype['protectionMode'] = undefined;

/**
 * Audit persistence mode
 * @member {module:model/AppConfiguration5.AuditPersistenceModeEnum} auditPersistenceMode
 */
AppConfiguration5.prototype['auditPersistenceMode'] = undefined;

/**
 * @member {module:model/CedarlingConfiguration} cedarlingConfiguration
 */
AppConfiguration5.prototype['cedarlingConfiguration'] = undefined;

/**
 * Active stat enabled
 * @member {Boolean} statEnabled
 */
AppConfiguration5.prototype['statEnabled'] = undefined;

/**
 * Statistical data capture time interval
 * @member {Number} statTimerIntervalInSeconds
 */
AppConfiguration5.prototype['statTimerIntervalInSeconds'] = undefined;

/**
 * List of token channel names
 * @member {Array.<String>} tokenChannels
 */
AppConfiguration5.prototype['tokenChannels'] = undefined;

/**
 * Lock Client ID
 * @member {String} clientId
 */
AppConfiguration5.prototype['clientId'] = undefined;

/**
 * Lock client password
 * @member {String} clientPassword
 */
AppConfiguration5.prototype['clientPassword'] = undefined;

/**
 * Choose whether to disable JDK loggers
 * @member {Boolean} disableJdkLogger
 */
AppConfiguration5.prototype['disableJdkLogger'] = undefined;

/**
 * Specify the logging level of loggers
 * @member {String} loggingLevel
 */
AppConfiguration5.prototype['loggingLevel'] = undefined;

/**
 * Logging layout used for Jans Authorization Server loggers
 * @member {String} loggingLayout
 */
AppConfiguration5.prototype['loggingLayout'] = undefined;

/**
 * The path to the external log4j2 logging configuration
 * @member {String} externalLoggerConfiguration
 */
AppConfiguration5.prototype['externalLoggerConfiguration'] = undefined;

/**
 * The interval for metric reporter in seconds
 * @member {Number} metricReporterInterval
 */
AppConfiguration5.prototype['metricReporterInterval'] = undefined;

/**
 * The days to keep metric reported data
 * @member {Number} metricReporterKeepDataDays
 */
AppConfiguration5.prototype['metricReporterKeepDataDays'] = undefined;

/**
 * Enable metric reporter
 * @member {Boolean} metricReporterEnabled
 */
AppConfiguration5.prototype['metricReporterEnabled'] = undefined;

/**
 * Time interval for the Clean Service in seconds
 * @member {Number} cleanServiceInterval
 */
AppConfiguration5.prototype['cleanServiceInterval'] = undefined;

/**
 * PubSub consumer service
 * @member {String} messageConsumerType
 */
AppConfiguration5.prototype['messageConsumerType'] = undefined;

/**
 * @member {Boolean} errorReasonEnabled
 */
AppConfiguration5.prototype['errorReasonEnabled'] = undefined;

/**
 * Each clean up iteration fetches chunk of expired data per base dn and removes it from storage
 * @member {Number} cleanServiceBatchChunkSize
 */
AppConfiguration5.prototype['cleanServiceBatchChunkSize'] = undefined;





/**
 * Allowed values for the <code>protectionMode</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration5['ProtectionModeEnum'] = {

    /**
     * value: "oauth"
     * @const
     */
    "oauth": "oauth",

    /**
     * value: "cedarling"
     * @const
     */
    "cedarling": "cedarling"
};


/**
 * Allowed values for the <code>auditPersistenceMode</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration5['AuditPersistenceModeEnum'] = {

    /**
     * value: "internal"
     * @const
     */
    "internal": "internal",

    /**
     * value: "config-api"
     * @const
     */
    "config-api": "config-api"
};



export default AppConfiguration5;

