/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import PluginConf from '../model/PluginConf';

/**
* Plugins service.
* @module api/PluginsApi
* @version OAS Version
*/
export default class PluginsApi {

    /**
    * Constructs a new PluginsApi. 
    * @alias module:api/PluginsApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the getPluginByName operation.
     * @callback module:api/PluginsApi~getPluginByNameCallback
     * @param {String} error Error message, if any.
     * @param {Boolean} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get plugin by name
     * Get plugin by name
     * @param {String} pluginName Plugin name
     * @param {module:api/PluginsApi~getPluginByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Boolean}
     */
    getPluginByName(pluginName, callback) {
      let postBody = null;
      // verify the required parameter 'pluginName' is set
      if (pluginName === undefined || pluginName === null) {
        throw new Error("Missing the required parameter 'pluginName' when calling getPluginByName");
      }

      let pathParams = {
        'pluginName': pluginName
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = 'Boolean';
      return this.apiClient.callApi(
        '/api/v1/plugin/{pluginName}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getPlugins operation.
     * @callback module:api/PluginsApi~getPluginsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/PluginConf>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Plugins
     * Gets list of Plugins
     * @param {module:api/PluginsApi~getPluginsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/PluginConf>}
     */
    getPlugins(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [PluginConf];
      return this.apiClient.callApi(
        '/api/v1/plugin', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
