/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import Client from '../model/Client';
import PagedResult from '../model/PagedResult';

/**
* OAuthOpenIDConnectClients service.
* @module api/OAuthOpenIDConnectClientsApi
* @version OAS Version
*/
export default class OAuthOpenIDConnectClientsApi {

    /**
    * Constructs a new OAuthOpenIDConnectClientsApi. 
    * @alias module:api/OAuthOpenIDConnectClientsApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteOauthOpenidClientByInum operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~deleteOauthOpenidClientByInumCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete OpenId Connect client
     * Delete OpenId Connect client
     * @param {String} inum Client identifier
     * @param {module:api/OAuthOpenIDConnectClientsApi~deleteOauthOpenidClientByInumCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteOauthOpenidClientByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteOauthOpenidClientByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/openid/clients/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthOpenidClients operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of OpenID Connect clients
     * Gets list of OpenID Connect clients
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getOauthOpenidClients(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/openid/clients', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthOpenidClientsByInum operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get OpenId Connect Client by Inum
     * Get OpenId Connect Client by Inum
     * @param {String} inum Client identifier
     * @param {module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
    getOauthOpenidClientsByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getOauthOpenidClientsByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Client;
      return this.apiClient.callApi(
        '/api/v1/openid/clients/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchOauthOpenidClientByInum operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~patchOauthOpenidClientByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch OpenId Connect client
     * Patch OpenId Connect client
     * @param {String} inum Client identifier
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/OAuthOpenIDConnectClientsApi~patchOauthOpenidClientByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
    patchOauthOpenidClientByInum(inum, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchOauthOpenidClientByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = Client;
      return this.apiClient.callApi(
        '/api/v1/openid/clients/{inum}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postOauthOpenidClient operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~postOauthOpenidClientCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new OpenId Connect client
     * Create new OpenId Connect client
     * @param {Object} opts Optional parameters
     * @param {module:model/Client} opts.client OpenID Connect Client object
     * @param {module:api/OAuthOpenIDConnectClientsApi~postOauthOpenidClientCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
    postOauthOpenidClient(opts, callback) {
      opts = opts || {};
      let postBody = opts['client'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Client;
      return this.apiClient.callApi(
        '/api/v1/openid/clients', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putOauthOpenidClient operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~putOauthOpenidClientCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update OpenId Connect client
     * Update OpenId Connect client
     * @param {Object} opts Optional parameters
     * @param {module:model/Client} opts.client OpenID Connect Client object
     * @param {module:api/OAuthOpenIDConnectClientsApi~putOauthOpenidClientCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
    putOauthOpenidClient(opts, callback) {
      opts = opts || {};
      let postBody = opts['client'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Client;
      return this.apiClient.callApi(
        '/api/v1/openid/clients', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
