/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import MessageConfiguration from '../model/MessageConfiguration';

/**
* MessageConfiguration service.
* @module api/MessageConfigurationApi
* @version OAS Version
*/
export default class MessageConfigurationApi {

    /**
    * Constructs a new MessageConfigurationApi. 
    * @alias module:api/MessageConfigurationApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the getConfigMessage operation.
     * @callback module:api/MessageConfigurationApi~getConfigMessageCallback
     * @param {String} error Error message, if any.
     * @param {module:model/MessageConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns message configuration.
     * Returns message configuration.
     * @param {module:api/MessageConfigurationApi~getConfigMessageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/MessageConfiguration}
     */
    getConfigMessage(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = MessageConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/message', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchConfigMessage operation.
     * @callback module:api/MessageConfigurationApi~patchConfigMessageCallback
     * @param {String} error Error message, if any.
     * @param {module:model/MessageConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch message configuration.
     * Patch message configuration
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/MessageConfigurationApi~patchConfigMessageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/MessageConfiguration}
     */
    patchConfigMessage(opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = MessageConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/message', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
