/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";

/**
* AgamaConfiguration service.
* @module api/AgamaConfigurationApi
* @version OAS Version
*/
export default class AgamaConfigurationApi {

    /**
    * Constructs a new AgamaConfigurationApi. 
    * @alias module:api/AgamaConfigurationApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the agamaSyntaxCheck operation.
     * @callback module:api/AgamaConfigurationApi~agamaSyntaxCheckCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Determine if the text passed is valid Agama code
     * Determine if the text passed is valid Agama code
     * @param {String} qname Agama Flow name
     * @param {Object} opts Optional parameters
     * @param {String} opts.body 
     * @param {module:api/AgamaConfigurationApi~agamaSyntaxCheckCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
    agamaSyntaxCheck(qname, opts, callback) {
      opts = opts || {};
      let postBody = opts['body'];
      // verify the required parameter 'qname' is set
      if (qname === undefined || qname === null) {
        throw new Error("Missing the required parameter 'qname' when calling agamaSyntaxCheck");
      }

      let pathParams = {
        'qname': qname
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['text/plain'];
      let accepts = ['application/json'];
      let returnType = 'String';
      return this.apiClient.callApi(
        '/api/v1/agama/syntax-check/{qname}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
