# JansConfigApi.SAMLIdentityBrokerApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSamlIdentityProvider**](SAMLIdentityBrokerApi.md#deleteSamlIdentityProvider) | **DELETE** /kc/saml/idp/{inum} | Delete SAML Identity Provider
[**getSamlIdentityProvider**](SAMLIdentityBrokerApi.md#getSamlIdentityProvider) | **GET** /kc/saml/idp | Retrieves SAML Identity Provider
[**getSamlIdentityProviderByInum**](SAMLIdentityBrokerApi.md#getSamlIdentityProviderByInum) | **GET** /kc/saml/idp/{inum} | Get SAML Identity Provider by Inum
[**getSamlSpMetadataJson**](SAMLIdentityBrokerApi.md#getSamlSpMetadataJson) | **GET** /kc/saml/idp/sp-metadata/{inum} | Get SAML SP Metadata as Json
[**getSamlSpMetadataUrl**](SAMLIdentityBrokerApi.md#getSamlSpMetadataUrl) | **GET** /kc/saml/idp/sp-metadata-file/{inum} | Get SAML SP Metadata Endpoint URL
[**postSamlIdentityProvider**](SAMLIdentityBrokerApi.md#postSamlIdentityProvider) | **POST** /kc/saml/idp/upload | Create SAML Identity Provider
[**putSamlIdentityProvider**](SAMLIdentityBrokerApi.md#putSamlIdentityProvider) | **PUT** /kc/saml/idp/upload | Update SAML Identity Provider



## deleteSamlIdentityProvider

> deleteSamlIdentityProvider(inum)

Delete SAML Identity Provider

Delete SAML Identity Provider

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let inum = "inum_example"; // String | Unique identifier
apiInstance.deleteSamlIdentityProvider(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Unique identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getSamlIdentityProvider

> IdentityProviderPagedResult getSamlIdentityProvider(opts)

Retrieves SAML Identity Provider

Retrieves SAML Identity Provider

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': displayName=saml-idp,realm=jans // String | Field and value pair for seraching
};
apiInstance.getSamlIdentityProvider(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**IdentityProviderPagedResult**](IdentityProviderPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getSamlIdentityProviderByInum

> IdentityProvider getSamlIdentityProviderByInum(inum)

Get SAML Identity Provider by Inum

Get SAML Identity Provider by Inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let inum = "inum_example"; // String | Unique identifier
apiInstance.getSamlIdentityProviderByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Unique identifier | 

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getSamlSpMetadataJson

> Object getSamlSpMetadataJson(inum)

Get SAML SP Metadata as Json

Get SAML SP Metadata as Json

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let inum = "inum_example"; // String | Unique identifier
apiInstance.getSamlSpMetadataJson(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Unique identifier | 

### Return type

**Object**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getSamlSpMetadataUrl

> String getSamlSpMetadataUrl(inum)

Get SAML SP Metadata Endpoint URL

Get SAML SP Metadata Endpoint URL

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let inum = "inum_example"; // String | Unique identifier
apiInstance.getSamlSpMetadataUrl(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Unique identifier | 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## postSamlIdentityProvider

> IdentityProvider postSamlIdentityProvider(identityProvider, metaDataFile)

Create SAML Identity Provider

Create SAML Identity Provider

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let identityProvider = new JansConfigApi.IdentityProvider(); // IdentityProvider | 
let metaDataFile = "/path/to/file"; // File | 
apiInstance.postSamlIdentityProvider(identityProvider, metaDataFile, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **identityProvider** | [**IdentityProvider**](IdentityProvider.md)|  | 
 **metaDataFile** | **File**|  | 

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json-patch+json


## putSamlIdentityProvider

> IdentityProvider putSamlIdentityProvider(identityProvider, metaDataFile)

Update SAML Identity Provider

Update SAML Identity Provider

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLIdentityBrokerApi();
let identityProvider = new JansConfigApi.IdentityProvider(); // IdentityProvider | 
let metaDataFile = "/path/to/file"; // File | 
apiInstance.putSamlIdentityProvider(identityProvider, metaDataFile, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **identityProvider** | [**IdentityProvider**](IdentityProvider.md)|  | 
 **metaDataFile** | **File**|  | 

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json-patch+json

