# JansConfigApi.MessageConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigMessage**](MessageConfigurationApi.md#getConfigMessage) | **GET** /api/v1/config/message | Returns message configuration.
[**patchConfigMessage**](MessageConfigurationApi.md#patchConfigMessage) | **PATCH** /api/v1/config/message | Patch message configuration.



## getConfigMessage

> MessageConfiguration getConfigMessage()

Returns message configuration.

Returns message configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationApi();
apiInstance.getConfigMessage((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**MessageConfiguration**](MessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigMessage

> MessageConfiguration patchConfigMessage(opts)

Patch message configuration.

Patch message configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationApi();
let opts = {
  'requestBody':  // [Object] | String representing patch-document.
};
apiInstance.patchConfigMessage(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**MessageConfiguration**](MessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json

