# JansConfigApi.LockLogApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**requestLockLogRecordsEventRange**](LockLogApi.md#requestLockLogRecordsEventRange) | **GET** /lock/audit/log/search | Rerquest log records for specific event range



## requestLockLogRecordsEventRange

> [LogEntry] requestLockLogRecordsEventRange(eventStartDate, eventEndDate, opts)

Rerquest log records for specific event range

Rerquest log records for specific event range

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockLogApi();
let eventStartDate = "eventStartDate_example"; // String | Event start date in ISO8601 format
let eventEndDate = "eventEndDate_example"; // String | Event end date in ISO8601 format
let opts = {
  'limit': 50 // Number | Search size - max size of the results to return
};
apiInstance.requestLockLogRecordsEventRange(eventStartDate, eventEndDate, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **eventStartDate** | **String**| Event start date in ISO8601 format | 
 **eventEndDate** | **String**| Event end date in ISO8601 format | 
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]

### Return type

[**[LogEntry]**](LogEntry.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

