# JansConfigApi.HealthCheckApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAppVersion**](HealthCheckApi.md#getAppVersion) | **GET** /api/v1/health/app-version | Returns application version
[**getConfigHealth**](HealthCheckApi.md#getConfigHealth) | **GET** /api/v1/health | Returns application health status
[**getConfigHealthLive**](HealthCheckApi.md#getConfigHealthLive) | **GET** /api/v1/health/live | Returns application liveness status
[**getConfigHealthReady**](HealthCheckApi.md#getConfigHealthReady) | **GET** /api/v1/health/ready | Returns application readiness status
[**getServerStat**](HealthCheckApi.md#getServerStat) | **GET** /api/v1/health/server-stat | Returns application server status
[**getServiceStatus**](HealthCheckApi.md#getServiceStatus) | **GET** /api/v1/health/service-status | Fetch service status



## getAppVersion

> Object getAppVersion(opts)

Returns application version

Returns application version

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.HealthCheckApi();
let opts = {
  'artifact': "'all'" // String | artifact name for which version is requied else ALL
};
apiInstance.getAppVersion(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **artifact** | **String**| artifact name for which version is requied else ALL | [optional] [default to &#39;all&#39;]

### Return type

**Object**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigHealth

> [HealthStatus] getConfigHealth()

Returns application health status

Returns application health status

### Example

```javascript
import JansConfigApi from 'jans_config_api';

let apiInstance = new JansConfigApi.HealthCheckApi();
apiInstance.getConfigHealth((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[HealthStatus]**](HealthStatus.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigHealthLive

> Status getConfigHealthLive()

Returns application liveness status

Returns application liveness status

### Example

```javascript
import JansConfigApi from 'jans_config_api';

let apiInstance = new JansConfigApi.HealthCheckApi();
apiInstance.getConfigHealthLive((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**Status**](Status.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigHealthReady

> Status getConfigHealthReady()

Returns application readiness status

Returns application readiness status

### Example

```javascript
import JansConfigApi from 'jans_config_api';

let apiInstance = new JansConfigApi.HealthCheckApi();
apiInstance.getConfigHealthReady((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**Status**](Status.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getServerStat

> StatsData getServerStat()

Returns application server status

Returns application server status

### Example

```javascript
import JansConfigApi from 'jans_config_api';

let apiInstance = new JansConfigApi.HealthCheckApi();
apiInstance.getServerStat((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**StatsData**](StatsData.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getServiceStatus

> Object getServiceStatus(opts)

Fetch service status

Fetch service status

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.HealthCheckApi();
let opts = {
  'service': "'all'" // String | Service name to check status
};
apiInstance.getServiceStatus(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **service** | **String**| Service name to check status | [optional] [default to &#39;all&#39;]

### Return type

**Object**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

