# JansConfigApi.DefaultAuthenticationMethodApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAcrs**](DefaultAuthenticationMethodApi.md#getAcrs) | **GET** /api/v1/acrs | Gets default authentication method.
[**putAcrs**](DefaultAuthenticationMethodApi.md#putAcrs) | **PUT** /api/v1/acrs | Updates default authentication method.



## getAcrs

> AuthenticationMethod getAcrs()

Gets default authentication method.

Gets default authentication method.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DefaultAuthenticationMethodApi();
apiInstance.getAcrs((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AuthenticationMethod**](AuthenticationMethod.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## putAcrs

> AuthenticationMethod putAcrs(opts)

Updates default authentication method.

Updates default authentication method.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DefaultAuthenticationMethodApi();
let opts = {
  'authenticationMethod': {
  "defaultAcr": "basic"
}
 // AuthenticationMethod | String representing patch-document.
};
apiInstance.putAcrs(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authenticationMethod** | [**AuthenticationMethod**](AuthenticationMethod.md)| String representing patch-document. | [optional] 

### Return type

[**AuthenticationMethod**](AuthenticationMethod.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

