# JansConfigApi.ConfigurationPropertiesApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getFeatureFlagType**](ConfigurationPropertiesApi.md#getFeatureFlagType) | **GET** /api/v1/jans-auth-server/config/feature-flags | Returns feature flags type configured for Jans authorization server.
[**getProperties**](ConfigurationPropertiesApi.md#getProperties) | **GET** /api/v1/jans-auth-server/config | Gets all Jans authorization server configuration properties.
[**getPropertiesPersistence**](ConfigurationPropertiesApi.md#getPropertiesPersistence) | **GET** /api/v1/jans-auth-server/config/persistence | Returns persistence type configured for Jans authorization server.
[**patchProperties**](ConfigurationPropertiesApi.md#patchProperties) | **PATCH** /api/v1/jans-auth-server/config | Partially modifies Jans authorization server Application configuration properties.



## getFeatureFlagType

> [String] getFeatureFlagType()

Returns feature flags type configured for Jans authorization server.

Returns feature flags type configured for Jans authorization server.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationPropertiesApi();
apiInstance.getFeatureFlagType((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**[String]**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getProperties

> AppConfiguration getProperties()

Gets all Jans authorization server configuration properties.

Gets all Jans authorization server configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationPropertiesApi();
apiInstance.getProperties((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AppConfiguration**](AppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getPropertiesPersistence

> PersistenceConfiguration getPropertiesPersistence()

Returns persistence type configured for Jans authorization server.

Returns persistence type configured for Jans authorization server.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationPropertiesApi();
apiInstance.getPropertiesPersistence((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**PersistenceConfiguration**](PersistenceConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchProperties

> AppConfiguration patchProperties(opts)

Partially modifies Jans authorization server Application configuration properties.

Partially modifies Jans authorization server AppConfiguration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationPropertiesApi();
let opts = {
  'requestBody': [
{"op":"add","path":"/authenticationFilters","value":[{}]},
{"op":"replace","path":"/useNestedJwtDuringEncryption","value":"true"},
{"op":"add","path":"/loggingLevel","value":"TRACE"}
]
 // [Object] | String representing patch-document.
};
apiInstance.patchProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**AppConfiguration**](AppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json

