"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _CedarlingConfiguration = _interopRequireDefault(require("./CedarlingConfiguration"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The AppConfiguration5 model module.
 * @module model/AppConfiguration5
 * @version OAS Version
 */
var AppConfiguration5 = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>AppConfiguration5</code>.
   * @alias module:model/AppConfiguration5
   */
  function AppConfiguration5() {
    _classCallCheck(this, AppConfiguration5);
    AppConfiguration5.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(AppConfiguration5, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>AppConfiguration5</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AppConfiguration5} obj Optional instance to populate.
     * @return {module:model/AppConfiguration5} The populated <code>AppConfiguration5</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new AppConfiguration5();
        if (data.hasOwnProperty('baseDN')) {
          obj['baseDN'] = _ApiClient["default"].convertToType(data['baseDN'], 'String');
        }
        if (data.hasOwnProperty('baseEndpoint')) {
          obj['baseEndpoint'] = _ApiClient["default"].convertToType(data['baseEndpoint'], 'String');
        }
        if (data.hasOwnProperty('openIdIssuer')) {
          obj['openIdIssuer'] = _ApiClient["default"].convertToType(data['openIdIssuer'], 'String');
        }
        if (data.hasOwnProperty('protectionMode')) {
          obj['protectionMode'] = _ApiClient["default"].convertToType(data['protectionMode'], 'String');
        }
        if (data.hasOwnProperty('auditPersistenceMode')) {
          obj['auditPersistenceMode'] = _ApiClient["default"].convertToType(data['auditPersistenceMode'], 'String');
        }
        if (data.hasOwnProperty('cedarlingConfiguration')) {
          obj['cedarlingConfiguration'] = _CedarlingConfiguration["default"].constructFromObject(data['cedarlingConfiguration']);
        }
        if (data.hasOwnProperty('statEnabled')) {
          obj['statEnabled'] = _ApiClient["default"].convertToType(data['statEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('statTimerIntervalInSeconds')) {
          obj['statTimerIntervalInSeconds'] = _ApiClient["default"].convertToType(data['statTimerIntervalInSeconds'], 'Number');
        }
        if (data.hasOwnProperty('tokenChannels')) {
          obj['tokenChannels'] = _ApiClient["default"].convertToType(data['tokenChannels'], ['String']);
        }
        if (data.hasOwnProperty('clientId')) {
          obj['clientId'] = _ApiClient["default"].convertToType(data['clientId'], 'String');
        }
        if (data.hasOwnProperty('clientPassword')) {
          obj['clientPassword'] = _ApiClient["default"].convertToType(data['clientPassword'], 'String');
        }
        if (data.hasOwnProperty('disableJdkLogger')) {
          obj['disableJdkLogger'] = _ApiClient["default"].convertToType(data['disableJdkLogger'], 'Boolean');
        }
        if (data.hasOwnProperty('loggingLevel')) {
          obj['loggingLevel'] = _ApiClient["default"].convertToType(data['loggingLevel'], 'String');
        }
        if (data.hasOwnProperty('loggingLayout')) {
          obj['loggingLayout'] = _ApiClient["default"].convertToType(data['loggingLayout'], 'String');
        }
        if (data.hasOwnProperty('externalLoggerConfiguration')) {
          obj['externalLoggerConfiguration'] = _ApiClient["default"].convertToType(data['externalLoggerConfiguration'], 'String');
        }
        if (data.hasOwnProperty('metricReporterInterval')) {
          obj['metricReporterInterval'] = _ApiClient["default"].convertToType(data['metricReporterInterval'], 'Number');
        }
        if (data.hasOwnProperty('metricReporterKeepDataDays')) {
          obj['metricReporterKeepDataDays'] = _ApiClient["default"].convertToType(data['metricReporterKeepDataDays'], 'Number');
        }
        if (data.hasOwnProperty('metricReporterEnabled')) {
          obj['metricReporterEnabled'] = _ApiClient["default"].convertToType(data['metricReporterEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('cleanServiceInterval')) {
          obj['cleanServiceInterval'] = _ApiClient["default"].convertToType(data['cleanServiceInterval'], 'Number');
        }
        if (data.hasOwnProperty('messageConsumerType')) {
          obj['messageConsumerType'] = _ApiClient["default"].convertToType(data['messageConsumerType'], 'String');
        }
        if (data.hasOwnProperty('errorReasonEnabled')) {
          obj['errorReasonEnabled'] = _ApiClient["default"].convertToType(data['errorReasonEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('cleanServiceBatchChunkSize')) {
          obj['cleanServiceBatchChunkSize'] = _ApiClient["default"].convertToType(data['cleanServiceBatchChunkSize'], 'Number');
        }
      }
      return obj;
    }
  }]);
}();
/**
 * Entry Base distinguished name (DN) that identifies the starting point of a search
 * @member {String} baseDN
 */
AppConfiguration5.prototype['baseDN'] = undefined;

/**
 * Lock base endpoint URL
 * @member {String} baseEndpoint
 */
AppConfiguration5.prototype['baseEndpoint'] = undefined;

/**
 * OpenID issuer URL
 * @member {String} openIdIssuer
 */
AppConfiguration5.prototype['openIdIssuer'] = undefined;

/**
 * Protection mode for the Lock server (OAuth or Cedarling)
 * @member {module:model/AppConfiguration5.ProtectionModeEnum} protectionMode
 */
AppConfiguration5.prototype['protectionMode'] = undefined;

/**
 * Audit persistence mode
 * @member {module:model/AppConfiguration5.AuditPersistenceModeEnum} auditPersistenceMode
 */
AppConfiguration5.prototype['auditPersistenceMode'] = undefined;

/**
 * @member {module:model/CedarlingConfiguration} cedarlingConfiguration
 */
AppConfiguration5.prototype['cedarlingConfiguration'] = undefined;

/**
 * Active stat enabled
 * @member {Boolean} statEnabled
 */
AppConfiguration5.prototype['statEnabled'] = undefined;

/**
 * Statistical data capture time interval
 * @member {Number} statTimerIntervalInSeconds
 */
AppConfiguration5.prototype['statTimerIntervalInSeconds'] = undefined;

/**
 * List of token channel names
 * @member {Array.<String>} tokenChannels
 */
AppConfiguration5.prototype['tokenChannels'] = undefined;

/**
 * Lock Client ID
 * @member {String} clientId
 */
AppConfiguration5.prototype['clientId'] = undefined;

/**
 * Lock client password
 * @member {String} clientPassword
 */
AppConfiguration5.prototype['clientPassword'] = undefined;

/**
 * Choose whether to disable JDK loggers
 * @member {Boolean} disableJdkLogger
 */
AppConfiguration5.prototype['disableJdkLogger'] = undefined;

/**
 * Specify the logging level of loggers
 * @member {String} loggingLevel
 */
AppConfiguration5.prototype['loggingLevel'] = undefined;

/**
 * Logging layout used for Jans Authorization Server loggers
 * @member {String} loggingLayout
 */
AppConfiguration5.prototype['loggingLayout'] = undefined;

/**
 * The path to the external log4j2 logging configuration
 * @member {String} externalLoggerConfiguration
 */
AppConfiguration5.prototype['externalLoggerConfiguration'] = undefined;

/**
 * The interval for metric reporter in seconds
 * @member {Number} metricReporterInterval
 */
AppConfiguration5.prototype['metricReporterInterval'] = undefined;

/**
 * The days to keep metric reported data
 * @member {Number} metricReporterKeepDataDays
 */
AppConfiguration5.prototype['metricReporterKeepDataDays'] = undefined;

/**
 * Enable metric reporter
 * @member {Boolean} metricReporterEnabled
 */
AppConfiguration5.prototype['metricReporterEnabled'] = undefined;

/**
 * Time interval for the Clean Service in seconds
 * @member {Number} cleanServiceInterval
 */
AppConfiguration5.prototype['cleanServiceInterval'] = undefined;

/**
 * PubSub consumer service
 * @member {String} messageConsumerType
 */
AppConfiguration5.prototype['messageConsumerType'] = undefined;

/**
 * @member {Boolean} errorReasonEnabled
 */
AppConfiguration5.prototype['errorReasonEnabled'] = undefined;

/**
 * Each clean up iteration fetches chunk of expired data per base dn and removes it from storage
 * @member {Number} cleanServiceBatchChunkSize
 */
AppConfiguration5.prototype['cleanServiceBatchChunkSize'] = undefined;

/**
 * Allowed values for the <code>protectionMode</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration5['ProtectionModeEnum'] = {
  /**
   * value: "oauth"
   * @const
   */
  "oauth": "oauth",
  /**
   * value: "cedarling"
   * @const
   */
  "cedarling": "cedarling"
};

/**
 * Allowed values for the <code>auditPersistenceMode</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration5['AuditPersistenceModeEnum'] = {
  /**
   * value: "internal"
   * @const
   */
  "internal": "internal",
  /**
   * value: "config-api"
   * @const
   */
  "config-api": "config-api"
};
var _default = exports["default"] = AppConfiguration5;