"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _GenericResponse = _interopRequireDefault(require("../model/GenericResponse"));
var _RolePermissionMapping = _interopRequireDefault(require("../model/RolePermissionMapping"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* AdminUIRolePermissionsMapping service.
* @module api/AdminUIRolePermissionsMappingApi
* @version OAS Version
*/
var AdminUIRolePermissionsMappingApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AdminUIRolePermissionsMappingApi. 
  * @alias module:api/AdminUIRolePermissionsMappingApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AdminUIRolePermissionsMappingApi(apiClient) {
    _classCallCheck(this, AdminUIRolePermissionsMappingApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the addRolePermissionsMapping operation.
   * @callback module:api/AdminUIRolePermissionsMappingApi~addRolePermissionsMappingCallback
   * @param {String} error Error message, if any.
   * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Add role-permissions mapping
   * Add role-permissions mapping
   * @param {Object} opts Optional parameters
   * @param {module:model/RolePermissionMapping} opts.rolePermissionMapping RolePermissionMapping object
   * @param {module:api/AdminUIRolePermissionsMappingApi~addRolePermissionsMappingCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link Array.<module:model/RolePermissionMapping>}
   */
  return _createClass(AdminUIRolePermissionsMappingApi, [{
    key: "addRolePermissionsMapping",
    value: function addRolePermissionsMapping(opts, callback) {
      opts = opts || {};
      var postBody = opts['rolePermissionMapping'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = [_RolePermissionMapping["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRolePermissionsMapping', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAdminuiRolePermissions operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~getAdminuiRolePermissionsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get admin ui role-permissions mapping by role-name
     * Get admin ui role-permissions mapping by role-name
     * @param {String} adminUIRole Admin UI Role
     * @param {module:api/AdminUIRolePermissionsMappingApi~getAdminuiRolePermissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
  }, {
    key: "getAdminuiRolePermissions",
    value: function getAdminuiRolePermissions(adminUIRole, callback) {
      var postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling getAdminuiRolePermissions");
      }
      var pathParams = {
        'adminUIRole': adminUIRole
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_RolePermissionMapping["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRolePermissionsMapping/{adminUIRole}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAllAdminuiRolePermissions operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~getAllAdminuiRolePermissionsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all admin ui role-permissions mapping
     * Get all admin ui role-permissions mapping
     * @param {module:api/AdminUIRolePermissionsMappingApi~getAllAdminuiRolePermissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
  }, {
    key: "getAllAdminuiRolePermissions",
    value: function getAllAdminuiRolePermissions(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_RolePermissionMapping["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRolePermissionsMapping', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the mapPermissionsToRole operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~mapPermissionsToRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Map permissions to role
     * Map permissions to role
     * @param {Object} opts Optional parameters
     * @param {module:model/RolePermissionMapping} opts.rolePermissionMapping RolePermissionMapping object
     * @param {module:api/AdminUIRolePermissionsMappingApi~mapPermissionsToRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
  }, {
    key: "mapPermissionsToRole",
    value: function mapPermissionsToRole(opts, callback) {
      opts = opts || {};
      var postBody = opts['rolePermissionMapping'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = [_RolePermissionMapping["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRolePermissionsMapping', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the removeRolePermissionsPermission operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~removeRolePermissionsPermissionCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Remove role-permissions mapping by role-name
     * Remove role-permissions mapping by role-name
     * @param {String} adminUIRole role
     * @param {module:api/AdminUIRolePermissionsMappingApi~removeRolePermissionsPermissionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
  }, {
    key: "removeRolePermissionsPermission",
    value: function removeRolePermissionsPermission(adminUIRole, callback) {
      var postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling removeRolePermissionsPermission");
      }
      var pathParams = {
        'adminUIRole': adminUIRole
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_RolePermissionMapping["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRolePermissionsMapping/{adminUIRole}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();