import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "label", "onClick", "onKeyDown", "size"];
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { isSizeLarge, isSizeSmall } from '../../utils';
import { sizeType } from '../../propTypes';
var propTypes = {
  label: PropTypes.string,
  onClick: PropTypes.func,
  onKeyDown: PropTypes.func,
  size: sizeType
};
/**
 * ClearButton
 *
 * http://getbootstrap.com/css/#helper-classes-close
 */
var ClearButton = function ClearButton(_ref) {
  var className = _ref.className,
    _ref$label = _ref.label,
    label = _ref$label === void 0 ? 'Clear' : _ref$label,
    _onClick = _ref.onClick,
    _onKeyDown = _ref.onKeyDown,
    size = _ref.size,
    props = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/React.createElement("button", _extends({}, props, {
    "aria-label": label,
    className: cx('close', 'btn-close', 'rbt-close', {
      'rbt-close-lg': isSizeLarge(size),
      'rbt-close-sm': isSizeSmall(size)
    }, className),
    onClick: function onClick(e) {
      e.stopPropagation();
      _onClick && _onClick(e);
    },
    onKeyDown: function onKeyDown(e) {
      // Prevent browser from navigating back.
      if (e.key === 'Backspace') {
        e.preventDefault();
      }
      _onKeyDown && _onKeyDown(e);
    },
    type: "button"
  }), /*#__PURE__*/React.createElement("span", {
    "aria-hidden": "true",
    className: "rbt-close-content"
  }, "\xD7"), /*#__PURE__*/React.createElement("span", {
    className: "sr-only visually-hidden"
  }, label));
};
ClearButton.propTypes = propTypes;
export default ClearButton;