/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import AppConfiguration from '../model/AppConfiguration';
import PersistenceConfiguration from '../model/PersistenceConfiguration';

/**
* ConfigurationProperties service.
* @module api/ConfigurationPropertiesApi
* @version OAS Version
*/
export default class ConfigurationPropertiesApi {

    /**
    * Constructs a new ConfigurationPropertiesApi. 
    * @alias module:api/ConfigurationPropertiesApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the getFeatureFlagType operation.
     * @callback module:api/ConfigurationPropertiesApi~getFeatureFlagTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns feature flags type configured for Jans authorization server.
     * Returns feature flags type configured for Jans authorization server.
     * @param {module:api/ConfigurationPropertiesApi~getFeatureFlagTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
    getFeatureFlagType(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ['String'];
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/config/feature-flags', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getProperties operation.
     * @callback module:api/ConfigurationPropertiesApi~getPropertiesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AppConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets all Jans authorization server configuration properties.
     * Gets all Jans authorization server configuration properties.
     * @param {module:api/ConfigurationPropertiesApi~getPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AppConfiguration}
     */
    getProperties(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = AppConfiguration;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/config', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getPropertiesPersistence operation.
     * @callback module:api/ConfigurationPropertiesApi~getPropertiesPersistenceCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PersistenceConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns persistence type configured for Jans authorization server.
     * Returns persistence type configured for Jans authorization server.
     * @param {module:api/ConfigurationPropertiesApi~getPropertiesPersistenceCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PersistenceConfiguration}
     */
    getPropertiesPersistence(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PersistenceConfiguration;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/config/persistence', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchProperties operation.
     * @callback module:api/ConfigurationPropertiesApi~patchPropertiesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AppConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Partially modifies Jans authorization server Application configuration properties.
     * Partially modifies Jans authorization server AppConfiguration properties.
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/ConfigurationPropertiesApi~patchPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AppConfiguration}
     */
    patchProperties(opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = AppConfiguration;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/config', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
