/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import AdminRole from '../model/AdminRole';
import GenericResponse from '../model/GenericResponse';

/**
* AdminUIRole service.
* @module api/AdminUIRoleApi
* @version OAS Version
*/
export default class AdminUIRoleApi {

    /**
    * Constructs a new AdminUIRoleApi. 
    * @alias module:api/AdminUIRoleApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the addAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~addAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Add admin ui role
     * Add admin ui role
     * @param {Object} opts Optional parameters
     * @param {module:model/AdminRole} opts.adminRole AdminRole object
     * @param {module:api/AdminUIRoleApi~addAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
    addAdminuiRole(opts, callback) {
      opts = opts || {};
      let postBody = opts['adminRole'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = [AdminRole];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRoles', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~deleteAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete admin ui role by role-name
     * Delete admin ui role by role-name
     * @param {String} adminUIRole Admin UI role
     * @param {module:api/AdminUIRoleApi~deleteAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
    deleteAdminuiRole(adminUIRole, callback) {
      let postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling deleteAdminuiRole");
      }

      let pathParams = {
        'adminUIRole': adminUIRole
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [AdminRole];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRoles/{adminUIRole}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the editAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~editAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Edit admin ui role
     * Edit admin ui role
     * @param {Object} opts Optional parameters
     * @param {module:model/AdminRole} opts.adminRole AdminRole object
     * @param {module:api/AdminUIRoleApi~editAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
    editAdminuiRole(opts, callback) {
      opts = opts || {};
      let postBody = opts['adminRole'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = [AdminRole];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRoles', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~getAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get admin ui role details by role-name
     * Get admin ui role details by role-name
     * @param {String} adminUIRole Admin UI role
     * @param {module:api/AdminUIRoleApi~getAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
    getAdminuiRole(adminUIRole, callback) {
      let postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling getAdminuiRole");
      }

      let pathParams = {
        'adminUIRole': adminUIRole
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [AdminRole];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRoles/{adminUIRole}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAllAdminuiRoles operation.
     * @callback module:api/AdminUIRoleApi~getAllAdminuiRolesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all admin ui roles
     * Get all admin ui roles
     * @param {module:api/AdminUIRoleApi~getAllAdminuiRolesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
    getAllAdminuiRoles(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [AdminRole];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRoles', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
