# JansConfigApi.StatisticsApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLockStat**](StatisticsApi.md#getLockStat) | **GET** /lock/lockStat | Provides basic statistic



## getLockStat

> [Object] getLockStat(opts)

Provides basic statistic

Provides basic statistic

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.StatisticsApi();
let opts = {
  'authorization': "authorization_example", // String | Authorization code
  'month': "month_example", // String | Month for which the stat report is to be fetched. The parameter is mandatory if start_month and end_month parameters are not present.
  'startMonth': "startMonth_example", // String | Start-Month for which the stat report is to be fetched
  'endMonth': "endMonth_example", // String | End-Month for which the stat report is to be fetched
  'format': "format_example" // String | Report format
};
apiInstance.getLockStat(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorization** | **String**| Authorization code | [optional] 
 **month** | **String**| Month for which the stat report is to be fetched. The parameter is mandatory if start_month and end_month parameters are not present. | [optional] 
 **startMonth** | **String**| Start-Month for which the stat report is to be fetched | [optional] 
 **endMonth** | **String**| End-Month for which the stat report is to be fetched | [optional] 
 **format** | **String**| Report format | [optional] 

### Return type

**[Object]**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

