# JansConfigApi.OAuthScopesApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteOauthScopesByInum**](OAuthScopesApi.md#deleteOauthScopesByInum) | **DELETE** /api/v1/scopes/{inum} | Delete Scope
[**getOauthScopes**](OAuthScopesApi.md#getOauthScopes) | **GET** /api/v1/scopes | Gets list of Scopes
[**getOauthScopesByInum**](OAuthScopesApi.md#getOauthScopesByInum) | **GET** /api/v1/scopes/{inum} | Get Scope by Inum
[**getScopeByCreator**](OAuthScopesApi.md#getScopeByCreator) | **GET** /api/v1/scopes/creator/{creatorId} | Get Scope by creatorId
[**getScopeByType**](OAuthScopesApi.md#getScopeByType) | **GET** /api/v1/scopes/type/{type} | Get Scope by type
[**patchOauthScopesById**](OAuthScopesApi.md#patchOauthScopesById) | **PATCH** /api/v1/scopes/{inum} | Patch Scope
[**postOauthScopes**](OAuthScopesApi.md#postOauthScopes) | **POST** /api/v1/scopes | Create Scope
[**putOauthScopes**](OAuthScopesApi.md#putOauthScopes) | **PUT** /api/v1/scopes | Update Scope



## deleteOauthScopesByInum

> deleteOauthScopesByInum(inum)

Delete Scope

Delete Scope

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let inum = "inum_example"; // String | Scope identifier
apiInstance.deleteOauthScopesByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Scope identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getOauthScopes

> PagedResult getOauthScopes(opts)

Gets list of Scopes

Gets list of Scopes

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let opts = {
  'type': "''", // String | Scope type
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'withAssociatedClients': false, // Boolean | Boolean fag to indicate if clients associated with the scope are to be returned
  'fieldValuePair': scopeType=spontaneous,defaultScope=true // String | Field and value pair for seraching
};
apiInstance.getOauthScopes(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **String**| Scope type | [optional] [default to &#39;&#39;]
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **withAssociatedClients** | **Boolean**| Boolean fag to indicate if clients associated with the scope are to be returned | [optional] [default to false]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getOauthScopesByInum

> CustomScope getOauthScopesByInum(inum, opts)

Get Scope by Inum

Get Scope by Inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let inum = "inum_example"; // String | Scope identifier
let opts = {
  'withAssociatedClients': false // Boolean | 
};
apiInstance.getOauthScopesByInum(inum, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Scope identifier | 
 **withAssociatedClients** | **Boolean**|  | [optional] [default to false]

### Return type

[**CustomScope**](CustomScope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getScopeByCreator

> [CustomScope] getScopeByCreator(creatorId)

Get Scope by creatorId

Get Scope by creatorId

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let creatorId = "creatorId_example"; // String | Id of the scope creator. If creator is client then client_id if user then user_id
apiInstance.getScopeByCreator(creatorId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **creatorId** | **String**| Id of the scope creator. If creator is client then client_id if user then user_id | 

### Return type

[**[CustomScope]**](CustomScope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getScopeByType

> [CustomScope] getScopeByType(type)

Get Scope by type

Get Scope by type

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let type = "type_example"; // String | Type of the scope
apiInstance.getScopeByType(type, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **String**| Type of the scope | 

### Return type

[**[CustomScope]**](CustomScope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchOauthScopesById

> Scope patchOauthScopesById(inum, opts)

Patch Scope

Patch Scope

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let inum = "inum_example"; // String | Scope identifier
let opts = {
  'requestBody': 
[{ "op": "replace", "path": "/umaAuthorizationPolicies", "value": ["inum=2DAF-F995,ou=scripts,o=jans"] }]
 // [Object] | String representing patch-document.
};
apiInstance.patchOauthScopesById(inum, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Scope identifier | 
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**Scope**](Scope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postOauthScopes

> Scope postOauthScopes(opts)

Create Scope

Create Scope

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let opts = {
  'scope': {
    "claims": [],
    "dynamicScopeScripts": [],
    "defaultScope": false,
    "attributes": {
        "spontaneousClientScopes": [],
        "showInConfigurationEndpoint": true
    },
    "id": "Scope5",
    "displayName": "Test Display Scope 5",
    "description": "TEST Description for Scope 5",
    "scopeType": "spontaneous",
    "iconUrl": "http://google.com",
    "umaAuthorizationPolicies": [
        "inum=2DAF-F9A5,ou=scripts,o=jans",
        "inum=2DAF-F995,ou=scripts,o=jans"
    ],
    "creatorType": "user",
    "creatorId": "2000.99b53b02-dfa1-42cd-aaef-b940d58bb03f"
}
 // Scope | Scope object
};
apiInstance.postOauthScopes(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scope** | [**Scope**](Scope.md)| Scope object | [optional] 

### Return type

[**Scope**](Scope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putOauthScopes

> Scope putOauthScopes(opts)

Update Scope

Update Scope

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthScopesApi();
let opts = {
  'scope': {
    "dn": "inum=9c4c6027-86b8-4afc-a68f-6b50579e6d21,ou=scopes,o=jans",
    "inum": "9c4c6027-86b8-4afc-a68f-6b50579e6d21",
    "displayName": "Test Display Scope 5",
    "id": "Scope5",
    "iconUrl": "http://google.com",
    "description": "TEST Description for Scope 5",
    "scopeType": "spontaneous",
    "defaultScope": false,
    "umaAuthorizationPolicies": [
        "inum=2DAF-F9A5,ou=scripts,o=jans",
        "inum=2DAF-F995,ou=scripts,o=jans"
    ],
    "attributes": {
        "showInConfigurationEndpoint": true
    },
    "creatorId": "2000.99b53b02-dfa1-42cd-aaef-b940d58bb03f",
    "creatorType": "user",
    "creationDate": "2022-10-27T21:09:45",
    "umaType": false,
    "baseDn": "inum=9c4c6027-86b8-4afc-a68f-6b50579e6d21,ou=scopes,o=jans"
}
 // Scope | Scope object
};
apiInstance.putOauthScopes(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scope** | [**Scope**](Scope.md)| Scope object | [optional] 

### Return type

[**Scope**](Scope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

