# JansConfigApi.ConfigurationConfigAPIApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigApiProperties**](ConfigurationConfigAPIApi.md#getConfigApiProperties) | **GET** /api/v1/api-config | Gets config-api configuration properties.
[**patchConfigApiProperties**](ConfigurationConfigAPIApi.md#patchConfigApiProperties) | **PATCH** /api/v1/api-config | Partially modifies config-api configuration properties.



## getConfigApiProperties

> ApiAppConfiguration getConfigApiProperties()

Gets config-api configuration properties.

Gets config-api configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationConfigAPIApi();
apiInstance.getConfigApiProperties((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**ApiAppConfiguration**](ApiAppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigApiProperties

> ApiAppConfiguration patchConfigApiProperties(opts)

Partially modifies config-api configuration properties.

Partially modifies config-api Configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationConfigAPIApi();
let opts = {
  'requestBody':  // [Object] | String representing patch-document.
};
apiInstance.patchConfigApiProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**ApiAppConfiguration**](ApiAppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json

