# JansConfigApi.AdminUIRolePermissionsMappingApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addRolePermissionsMapping**](AdminUIRolePermissionsMappingApi.md#addRolePermissionsMapping) | **POST** /admin-ui/adminUIRolePermissionsMapping | Add role-permissions mapping
[**getAdminuiRolePermissions**](AdminUIRolePermissionsMappingApi.md#getAdminuiRolePermissions) | **GET** /admin-ui/adminUIRolePermissionsMapping/{adminUIRole} | Get admin ui role-permissions mapping by role-name
[**getAllAdminuiRolePermissions**](AdminUIRolePermissionsMappingApi.md#getAllAdminuiRolePermissions) | **GET** /admin-ui/adminUIRolePermissionsMapping | Get all admin ui role-permissions mapping
[**mapPermissionsToRole**](AdminUIRolePermissionsMappingApi.md#mapPermissionsToRole) | **PUT** /admin-ui/adminUIRolePermissionsMapping | Map permissions to role
[**removeRolePermissionsPermission**](AdminUIRolePermissionsMappingApi.md#removeRolePermissionsPermission) | **DELETE** /admin-ui/adminUIRolePermissionsMapping/{adminUIRole} | Remove role-permissions mapping by role-name



## addRolePermissionsMapping

> [RolePermissionMapping] addRolePermissionsMapping(opts)

Add role-permissions mapping

Add role-permissions mapping

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRolePermissionsMappingApi();
let opts = {
  'rolePermissionMapping': new JansConfigApi.RolePermissionMapping() // RolePermissionMapping | RolePermissionMapping object
};
apiInstance.addRolePermissionsMapping(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **rolePermissionMapping** | [**RolePermissionMapping**](RolePermissionMapping.md)| RolePermissionMapping object | [optional] 

### Return type

[**[RolePermissionMapping]**](RolePermissionMapping.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## getAdminuiRolePermissions

> [RolePermissionMapping] getAdminuiRolePermissions(adminUIRole)

Get admin ui role-permissions mapping by role-name

Get admin ui role-permissions mapping by role-name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRolePermissionsMappingApi();
let adminUIRole = "adminUIRole_example"; // String | Admin UI Role
apiInstance.getAdminuiRolePermissions(adminUIRole, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminUIRole** | **String**| Admin UI Role | 

### Return type

[**[RolePermissionMapping]**](RolePermissionMapping.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAllAdminuiRolePermissions

> [RolePermissionMapping] getAllAdminuiRolePermissions()

Get all admin ui role-permissions mapping

Get all admin ui role-permissions mapping

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRolePermissionsMappingApi();
apiInstance.getAllAdminuiRolePermissions((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[RolePermissionMapping]**](RolePermissionMapping.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## mapPermissionsToRole

> [RolePermissionMapping] mapPermissionsToRole(opts)

Map permissions to role

Map permissions to role

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRolePermissionsMappingApi();
let opts = {
  'rolePermissionMapping': new JansConfigApi.RolePermissionMapping() // RolePermissionMapping | RolePermissionMapping object
};
apiInstance.mapPermissionsToRole(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **rolePermissionMapping** | [**RolePermissionMapping**](RolePermissionMapping.md)| RolePermissionMapping object | [optional] 

### Return type

[**[RolePermissionMapping]**](RolePermissionMapping.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## removeRolePermissionsPermission

> [RolePermissionMapping] removeRolePermissionsPermission(adminUIRole)

Remove role-permissions mapping by role-name

Remove role-permissions mapping by role-name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRolePermissionsMappingApi();
let adminUIRole = "adminUIRole_example"; // String | role
apiInstance.removeRolePermissionsPermission(adminUIRole, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminUIRole** | **String**| role | 

### Return type

[**[RolePermissionMapping]**](RolePermissionMapping.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

