"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _PolicySource = _interopRequireDefault(require("./PolicySource"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The CedarlingConfiguration model module.
 * @module model/CedarlingConfiguration
 * @version OAS Version
 */
var CedarlingConfiguration = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>CedarlingConfiguration</code>.
   * Cedarling configuration
   * @alias module:model/CedarlingConfiguration
   */
  function CedarlingConfiguration() {
    _classCallCheck(this, CedarlingConfiguration);
    CedarlingConfiguration.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(CedarlingConfiguration, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>CedarlingConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CedarlingConfiguration} obj Optional instance to populate.
     * @return {module:model/CedarlingConfiguration} The populated <code>CedarlingConfiguration</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new CedarlingConfiguration();
        if (data.hasOwnProperty('enabled')) {
          obj['enabled'] = _ApiClient["default"].convertToType(data['enabled'], 'Boolean');
        }
        if (data.hasOwnProperty('policySources')) {
          obj['policySources'] = _ApiClient["default"].convertToType(data['policySources'], [_PolicySource["default"]]);
        }
        if (data.hasOwnProperty('logType')) {
          obj['logType'] = _ApiClient["default"].convertToType(data['logType'], 'String');
        }
        if (data.hasOwnProperty('logLevel')) {
          obj['logLevel'] = _ApiClient["default"].convertToType(data['logLevel'], 'String');
        }
        if (data.hasOwnProperty('externalPolicyStoreUri')) {
          obj['externalPolicyStoreUri'] = _ApiClient["default"].convertToType(data['externalPolicyStoreUri'], 'String');
        }
      }
      return obj;
    }
  }]);
}();
/**
 * Specify if Cedraling is enabled
 * @member {Boolean} enabled
 */
CedarlingConfiguration.prototype['enabled'] = undefined;

/**
 * List of Policy Sources
 * @member {Array.<module:model/PolicySource>} policySources
 */
CedarlingConfiguration.prototype['policySources'] = undefined;

/**
 * Log type: off, memory, std_out
 * @member {module:model/CedarlingConfiguration.LogTypeEnum} logType
 */
CedarlingConfiguration.prototype['logType'] = undefined;

/**
 * System Log Level
 * @member {module:model/CedarlingConfiguration.LogLevelEnum} logLevel
 */
CedarlingConfiguration.prototype['logLevel'] = undefined;

/**
 * External policy store URI
 * @member {String} externalPolicyStoreUri
 */
CedarlingConfiguration.prototype['externalPolicyStoreUri'] = undefined;

/**
 * Allowed values for the <code>logType</code> property.
 * @enum {String}
 * @readonly
 */
CedarlingConfiguration['LogTypeEnum'] = {
  /**
   * value: "OFF"
   * @const
   */
  "OFF": "OFF",
  /**
   * value: "MEMORY"
   * @const
   */
  "MEMORY": "MEMORY",
  /**
   * value: "STD_OUT"
   * @const
   */
  "STD_OUT": "STD_OUT"
};

/**
 * Allowed values for the <code>logLevel</code> property.
 * @enum {String}
 * @readonly
 */
CedarlingConfiguration['LogLevelEnum'] = {
  /**
   * value: "FATAL"
   * @const
   */
  "FATAL": "FATAL",
  /**
   * value: "ERROR"
   * @const
   */
  "ERROR": "ERROR",
  /**
   * value: "WARN"
   * @const
   */
  "WARN": "WARN",
  /**
   * value: "INFO"
   * @const
   */
  "INFO": "INFO",
  /**
   * value: "DEBUG"
   * @const
   */
  "DEBUG": "DEBUG",
  /**
   * value: "TRACE"
   * @const
   */
  "TRACE": "TRACE"
};
var _default = exports["default"] = CedarlingConfiguration;