"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ApiError = _interopRequireDefault(require("../model/ApiError"));
var _TrustRelationship = _interopRequireDefault(require("../model/TrustRelationship"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* SAMLTrustRelationship service.
* @module api/SAMLTrustRelationshipApi
* @version OAS Version
*/
var SAMLTrustRelationshipApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new SAMLTrustRelationshipApi. 
  * @alias module:api/SAMLTrustRelationshipApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function SAMLTrustRelationshipApi(apiClient) {
    _classCallCheck(this, SAMLTrustRelationshipApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteTrustRelationship operation.
   * @callback module:api/SAMLTrustRelationshipApi~deleteTrustRelationshipCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete TrustRelationship
   * Delete TrustRelationship
   * @param {String} id Unique Id of Trust Relationship
   * @param {module:api/SAMLTrustRelationshipApi~deleteTrustRelationshipCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(SAMLTrustRelationshipApi, [{
    key: "deleteTrustRelationship",
    value: function deleteTrustRelationship(id, callback) {
      var postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteTrustRelationship");
      }
      var pathParams = {
        'id': id
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/kc/saml/trust-relationship/{id}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getTrustRelationshipById operation.
     * @callback module:api/SAMLTrustRelationshipApi~getTrustRelationshipByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TrustRelationship} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get TrustRelationship by Id
     * Get TrustRelationship by Id
     * @param {String} id Unique identifier - Id
     * @param {module:api/SAMLTrustRelationshipApi~getTrustRelationshipByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TrustRelationship}
     */
  }, {
    key: "getTrustRelationshipById",
    value: function getTrustRelationshipById(id, callback) {
      var postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getTrustRelationshipById");
      }
      var pathParams = {
        'id': id
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _TrustRelationship["default"];
      return this.apiClient.callApi('/kc/saml/trust-relationship/id/{id}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getTrustRelationshipFileMetadata operation.
     * @callback module:api/SAMLTrustRelationshipApi~getTrustRelationshipFileMetadataCallback
     * @param {String} error Error message, if any.
     * @param {File} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get TrustRelationship file metadata
     * Get TrustRelationship file metadata
     * @param {String} id TrustRelationship inum
     * @param {module:api/SAMLTrustRelationshipApi~getTrustRelationshipFileMetadataCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link File}
     */
  }, {
    key: "getTrustRelationshipFileMetadata",
    value: function getTrustRelationshipFileMetadata(id, callback) {
      var postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getTrustRelationshipFileMetadata");
      }
      var pathParams = {
        'id': id
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/xml', 'application/json'];
      var returnType = File;
      return this.apiClient.callApi('/kc/saml/trust-relationship/sp-metadata-file/{id}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getTrustRelationships operation.
     * @callback module:api/SAMLTrustRelationshipApi~getTrustRelationshipsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/TrustRelationship>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all Trust Relationship
     * Get all TrustRelationship.
     * @param {module:api/SAMLTrustRelationshipApi~getTrustRelationshipsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/TrustRelationship>}
     */
  }, {
    key: "getTrustRelationships",
    value: function getTrustRelationships(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_TrustRelationship["default"]];
      return this.apiClient.callApi('/kc/saml/trust-relationship', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postTrustRelationshipMetadataFile operation.
     * @callback module:api/SAMLTrustRelationshipApi~postTrustRelationshipMetadataFileCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TrustRelationship} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create Trust Relationship with Metadata File
     * Create Trust Relationship with Metadata File
     * @param {module:model/TrustRelationship} trustRelationship 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLTrustRelationshipApi~postTrustRelationshipMetadataFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TrustRelationship}
     */
  }, {
    key: "postTrustRelationshipMetadataFile",
    value: function postTrustRelationshipMetadataFile(trustRelationship, metaDataFile, callback) {
      var postBody = null;
      // verify the required parameter 'trustRelationship' is set
      if (trustRelationship === undefined || trustRelationship === null) {
        throw new Error("Missing the required parameter 'trustRelationship' when calling postTrustRelationshipMetadataFile");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling postTrustRelationshipMetadataFile");
      }
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {
        'trustRelationship': trustRelationship,
        'metaDataFile': metaDataFile
      };
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json'];
      var returnType = _TrustRelationship["default"];
      return this.apiClient.callApi('/kc/saml/trust-relationship/upload', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putTrustRelationship operation.
     * @callback module:api/SAMLTrustRelationshipApi~putTrustRelationshipCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TrustRelationship} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update TrustRelationship
     * Update TrustRelationship
     * @param {module:model/TrustRelationship} trustRelationship 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLTrustRelationshipApi~putTrustRelationshipCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TrustRelationship}
     */
  }, {
    key: "putTrustRelationship",
    value: function putTrustRelationship(trustRelationship, metaDataFile, callback) {
      var postBody = null;
      // verify the required parameter 'trustRelationship' is set
      if (trustRelationship === undefined || trustRelationship === null) {
        throw new Error("Missing the required parameter 'trustRelationship' when calling putTrustRelationship");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling putTrustRelationship");
      }
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {
        'trustRelationship': trustRelationship,
        'metaDataFile': metaDataFile
      };
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json'];
      var returnType = _TrustRelationship["default"];
      return this.apiClient.callApi('/kc/saml/trust-relationship/upload', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();