"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _JSONWebKey = _interopRequireDefault(require("../model/JSONWebKey"));
var _WebKeysConfiguration = _interopRequireDefault(require("../model/WebKeysConfiguration"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* ConfigurationJWKJSONWebKeyJWK service.
* @module api/ConfigurationJWKJSONWebKeyJWKApi
* @version OAS Version
*/
var ConfigurationJWKJSONWebKeyJWKApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new ConfigurationJWKJSONWebKeyJWKApi. 
  * @alias module:api/ConfigurationJWKJSONWebKeyJWKApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function ConfigurationJWKJSONWebKeyJWKApi(apiClient) {
    _classCallCheck(this, ConfigurationJWKJSONWebKeyJWKApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteConfigJwkKid operation.
   * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~deleteConfigJwkKidCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete a JSON Web Key based on kid
   * Delete a JSON Web Key based on kid
   * @param {String} kid The unique identifier for the key
   * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~deleteConfigJwkKidCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(ConfigurationJWKJSONWebKeyJWKApi, [{
    key: "deleteConfigJwkKid",
    value: function deleteConfigJwkKid(kid, callback) {
      var postBody = null;
      // verify the required parameter 'kid' is set
      if (kid === undefined || kid === null) {
        throw new Error("Missing the required parameter 'kid' when calling deleteConfigJwkKid");
      }
      var pathParams = {
        'kid': kid
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/config/jwks/{kid}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigJwks operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~getConfigJwksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebKeysConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of JSON Web Key (JWK) used by server
     * Gets list of JSON Web Key (JWK) used by server
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~getConfigJwksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebKeysConfiguration}
     */
  }, {
    key: "getConfigJwks",
    value: function getConfigJwks(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _WebKeysConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/jwks', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getJwkByKid operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~getJwkByKidCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JSONWebKey} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a JSON Web Key based on kid
     * Get a JSON Web Key based on kid
     * @param {String} kid The unique identifier for the key
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~getJwkByKidCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JSONWebKey}
     */
  }, {
    key: "getJwkByKid",
    value: function getJwkByKid(kid, callback) {
      var postBody = null;
      // verify the required parameter 'kid' is set
      if (kid === undefined || kid === null) {
        throw new Error("Missing the required parameter 'kid' when calling getJwkByKid");
      }
      var pathParams = {
        'kid': kid
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _JSONWebKey["default"];
      return this.apiClient.callApi('/api/v1/config/jwks/{kid}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchConfigJwkKid operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwkKidCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JSONWebKey} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch a specific JSON Web Key based on kid
     * Patch a specific JSON Web Key based on kid
     * @param {String} kid The unique identifier for the key
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwkKidCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JSONWebKey}
     */
  }, {
    key: "patchConfigJwkKid",
    value: function patchConfigJwkKid(kid, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'kid' is set
      if (kid === undefined || kid === null) {
        throw new Error("Missing the required parameter 'kid' when calling patchConfigJwkKid");
      }
      var pathParams = {
        'kid': kid
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _JSONWebKey["default"];
      return this.apiClient.callApi('/api/v1/config/jwks/{kid}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchConfigJwks operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebKeysConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patches JSON Web Keys
     * Patches JSON Web Keys
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebKeysConfiguration}
     */
  }, {
    key: "patchConfigJwks",
    value: function patchConfigJwks(opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _WebKeysConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/jwks', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postConfigJwksKey operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~postConfigJwksKeyCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JSONWebKey} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Configuration – JWK - JSON Web Key (JWK)
     * Configuration – JWK - JSON Web Key (JWK)
     * @param {Object} opts Optional parameters
     * @param {module:model/JSONWebKey} opts.jSONWebKey JSONWebKey object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~postConfigJwksKeyCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JSONWebKey}
     */
  }, {
    key: "postConfigJwksKey",
    value: function postConfigJwksKey(opts, callback) {
      opts = opts || {};
      var postBody = opts['jSONWebKey'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _JSONWebKey["default"];
      return this.apiClient.callApi('/api/v1/config/jwks/key', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putConfigJwks operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~putConfigJwksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebKeysConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Replaces JSON Web Keys
     * Replaces JSON Web Keys
     * @param {Object} opts Optional parameters
     * @param {module:model/WebKeysConfiguration} opts.webKeysConfiguration JSON Web Keys object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~putConfigJwksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebKeysConfiguration}
     */
  }, {
    key: "putConfigJwks",
    value: function putConfigJwks(opts, callback) {
      opts = opts || {};
      var postBody = opts['webKeysConfiguration'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _WebKeysConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/jwks', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();