"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _JansAttribute = _interopRequireDefault(require("../model/JansAttribute"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
var _PatchRequest = _interopRequireDefault(require("../model/PatchRequest"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* Attribute service.
* @module api/AttributeApi
* @version OAS Version
*/
var AttributeApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AttributeApi. 
  * @alias module:api/AttributeApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AttributeApi(apiClient) {
    _classCallCheck(this, AttributeApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteAttributesByInum operation.
   * @callback module:api/AttributeApi~deleteAttributesByInumCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Deletes an attribute based on inum
   * Deletes an attribute based on inum
   * @param {String} inum Attribute Id
   * @param {module:api/AttributeApi~deleteAttributesByInumCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(AttributeApi, [{
    key: "deleteAttributesByInum",
    value: function deleteAttributesByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteAttributesByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/attributes/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAttributes operation.
     * @callback module:api/AttributeApi~getAttributesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets a list of Jans attributes.
     * Gets a list of Jans attributes.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {String} opts.status Status of the attribute (default to 'all')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/AttributeApi~getAttributesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getAttributes",
    value: function getAttributes(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'status': opts['status'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/attributes', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAttributesByInum operation.
     * @callback module:api/AttributeApi~getAttributesByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an attribute based on inum
     * Gets an attribute based on inum
     * @param {String} inum Attribute Id
     * @param {module:api/AttributeApi~getAttributesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
  }, {
    key: "getAttributesByInum",
    value: function getAttributesByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getAttributesByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _JansAttribute["default"];
      return this.apiClient.callApi('/api/v1/attributes/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchAttributesByInum operation.
     * @callback module:api/AttributeApi~patchAttributesByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Partially modify a JansAttribute
     * Partially modify a JansAttribute
     * @param {String} inum Attribute Id
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/PatchRequest>} opts.patchRequest String representing patch-document.
     * @param {module:api/AttributeApi~patchAttributesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
  }, {
    key: "patchAttributesByInum",
    value: function patchAttributesByInum(inum, opts, callback) {
      opts = opts || {};
      var postBody = opts['patchRequest'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchAttributesByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _JansAttribute["default"];
      return this.apiClient.callApi('/api/v1/attributes/{inum}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postAttributes operation.
     * @callback module:api/AttributeApi~postAttributesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Adds a new attribute
     * Adds a new attribute
     * @param {Object} opts Optional parameters
     * @param {module:model/JansAttribute} opts.jansAttribute JansAttribute object
     * @param {module:api/AttributeApi~postAttributesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
  }, {
    key: "postAttributes",
    value: function postAttributes(opts, callback) {
      opts = opts || {};
      var postBody = opts['jansAttribute'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _JansAttribute["default"];
      return this.apiClient.callApi('/api/v1/attributes', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putAttributes operation.
     * @callback module:api/AttributeApi~putAttributesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates an existing attribute
     * Updates an existing attribute
     * @param {Object} opts Optional parameters
     * @param {module:model/JansAttribute} opts.jansAttribute JansAttribute object
     * @param {module:api/AttributeApi~putAttributesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
  }, {
    key: "putAttributes",
    value: function putAttributes(opts, callback) {
      opts = opts || {};
      var postBody = opts['jansAttribute'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _JansAttribute["default"];
      return this.apiClient.callApi('/api/v1/attributes', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();