import type { blockTags, inlineTags, modifierTags } from "../utils/options/tsdoc-defaults.js";
import translatable from "./locales/en.cjs";
export type BuiltinTranslatableStringArgs = {
    [K in keyof typeof translatable]: BuildTranslationArguments<(typeof translatable)[K]>;
} & Record<(typeof blockTags)[number] | (typeof inlineTags)[number] | (typeof modifierTags)[number] extends `@${infer T}` ? `tag_${T}` : never, [
]>;
type BuildTranslationArguments<T extends string, Acc extends any[] = []> = T extends `${string}{${bigint}}${infer R}` ? BuildTranslationArguments<R, [...Acc, string]> : Acc;
export type BuiltinTranslatableStringConstraints = {
    [K in keyof BuiltinTranslatableStringArgs]: TranslationConstraint[BuiltinTranslatableStringArgs[K]["length"]];
};
type BuildConstraint<T extends number, Acc extends string = "", U extends number = T> = [T] extends [never] ? `${Acc}${string}` : T extends T ? BuildConstraint<Exclude<U, T>, `${Acc}${string}{${T}}`> : never;
type TranslationConstraint = [
    string,
    BuildConstraint<0>,
    BuildConstraint<0 | 1>,
    BuildConstraint<0 | 1 | 2>,
    BuildConstraint<0 | 1 | 2 | 3>,
    BuildConstraint<0 | 1 | 2 | 3 | 4>,
    BuildConstraint<0 | 1 | 2 | 3 | 4 | 5>
];
export {};
