"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _ClearButton = _interopRequireDefault(require("../ClearButton"));
var _token = require("../../behaviors/token");
var _utils = require("../../utils");
var _excluded = ["active", "children", "className", "onRemove", "tabIndex"],
  _excluded2 = ["children", "option", "readOnly"],
  _excluded3 = ["ref"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { "default": e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n["default"] = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2["default"])(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var InteractiveToken = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var active = _ref.active,
    children = _ref.children,
    className = _ref.className,
    onRemove = _ref.onRemove,
    tabIndex = _ref.tabIndex,
    props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return /*#__PURE__*/_react["default"].createElement("div", (0, _extends2["default"])({}, props, {
    className: (0, _classnames["default"])('rbt-token', 'rbt-token-removeable', {
      'rbt-token-active': !!active
    }, className),
    ref: ref,
    tabIndex: tabIndex || 0
  }), children, /*#__PURE__*/_react["default"].createElement(_ClearButton["default"], {
    className: "rbt-token-remove-button",
    label: "Remove",
    onClick: onRemove,
    tabIndex: -1
  }));
});
var StaticToken = function StaticToken(_ref2) {
  var children = _ref2.children,
    className = _ref2.className,
    disabled = _ref2.disabled,
    href = _ref2.href;
  var classnames = (0, _classnames["default"])('rbt-token', {
    'rbt-token-disabled': disabled
  }, className);
  if (href && !disabled) {
    return /*#__PURE__*/_react["default"].createElement("a", {
      className: classnames,
      href: href
    }, children);
  }
  return /*#__PURE__*/_react["default"].createElement("div", {
    className: classnames
  }, children);
};
/**
 * Individual token component, generally displayed within the
 * `TypeaheadInputMulti` component, but can also be rendered on its own.
 */
var Token = function Token(_ref3) {
  var children = _ref3.children,
    option = _ref3.option,
    readOnly = _ref3.readOnly,
    props = (0, _objectWithoutProperties2["default"])(_ref3, _excluded2);
  var _useToken = (0, _token.useToken)(_objectSpread(_objectSpread({}, props), {}, {
      option: option
    })),
    ref = _useToken.ref,
    tokenProps = (0, _objectWithoutProperties2["default"])(_useToken, _excluded3);
  var child = /*#__PURE__*/_react["default"].createElement("div", {
    className: "rbt-token-label"
  }, children);
  return !props.disabled && !readOnly && (0, _utils.isFunction)(tokenProps.onRemove) ? /*#__PURE__*/_react["default"].createElement(InteractiveToken, (0, _extends2["default"])({}, props, tokenProps, {
    ref: ref
  }), child) : /*#__PURE__*/_react["default"].createElement(StaticToken, props, child);
};
var _default = exports["default"] = Token;